/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;

public class ValidMetadataValues {
    private final OpenMetadataClient openMetadataStore;
    private final String userId;

    public ValidMetadataValues(OpenMetadataClient openMetadataStore, String userId) {
        this.openMetadataStore = openMetadataStore;
        this.userId = userId;
    }

    public void setUpValidMetadataValue(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.setUpValidMetadataValue(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapName(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.setUpValidMetadataMapName(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapValue(String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.setUpValidMetadataMapValue(this.userId, typeName, propertyName, mapName, validMetadataValue);
    }

    public void clearValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.clearValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.clearValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.clearValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public boolean validateMetadataValue(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.validateMetadataValue(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapName(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.validateMetadataMapName(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapValue(String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.validateMetadataMapValue(this.userId, typeName, propertyName, mapName, actualValue);
    }

    public ValidMetadataValue getValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public List<ValidMetadataValueDetail> getValidMetadataValues(String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStore.getValidMetadataValues(this.userId, typeName, propertyName, startFrom, pageSize);
    }
}

