/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;

public class IntegrationContextManager {
    protected String partnerOMASPlatformRootURL = null;
    protected String partnerOMASServerName = null;
    protected OpenIntegrationClient openIntegrationClient = null;
    protected OpenMetadataClient openMetadataStoreClient = null;
    protected String localServerUserId = null;
    protected String localServerPassword = null;
    protected Map<String, Object> serviceOptions = null;
    protected int maxPageSize = 0;
    protected AuditLog auditLog = null;

    protected IntegrationContextManager() {
    }

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        this.partnerOMASPlatformRootURL = partnerOMASPlatformRootURL;
        this.partnerOMASServerName = partnerOMASServerName;
        this.localServerUserId = userId;
        this.localServerPassword = password;
        this.serviceOptions = serviceOptions;
        this.maxPageSize = maxPageSize;
        this.auditLog = auditLog;
    }

    public void createClients() throws InvalidParameterException {
    }

    protected String setUpMetadataSource(String metadataSourceQualifiedName, String typeName, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.openIntegrationClient != null) {
            String metadataSourceGUID = this.openIntegrationClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
            if (metadataSourceGUID == null) {
                metadataSourceGUID = this.openIntegrationClient.createMetadataSource(this.localServerUserId, typeName, classificationName, metadataSourceQualifiedName);
            }
            return metadataSourceGUID;
        }
        return null;
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        IntegrationContext integrationContext = null;
        String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, null, null);
        String externalSourceName = metadataSourceQualifiedName;
        if (externalSourceGUID == null) {
            externalSourceName = null;
        }
        if (this.openIntegrationClient != null && this.openMetadataStoreClient != null) {
            integrationContext = new IntegrationContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, this.maxPageSize);
        }
        integrationConnector.setContext(integrationContext);
        integrationConnector.setConnectorName(connectorName);
        return integrationContext;
    }
}

