/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OIFErrorCode implements ExceptionMessageSet
{
    ENGAGE_IMPLEMENTATION_MISSING(400, "OIF-CONNECTOR-400-001", "The integration connector {0} has been configured to have its own thread to issue blocking calls but has not implemented the engage() method", "The integration daemon created a separate thread for this connector to enable it to issue blocking calls.  It called the engage() method on this thread.  However, the default implementation of the engage() method has been invoked suggesting that either the dedicated thread is not needed or there is an error in the implementation of the connector.  The integration daemon will terminate the thread once the engage() method returns.", "If the connector does not need to issue blocking calls update the configuration to remove the need for the dedicated thread.  Otherwise update the integration connector's implementation to override the default engage() method implementation.");

    private final ExceptionMessageDefinition messageDefinition;
    private static final Logger log;

    private OIFErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    @Deprecated
    public int getHTTPErrorCode() {
        return this.messageDefinition.getHttpErrorCode();
    }

    @Deprecated
    public String getErrorMessageId() {
        return this.messageDefinition.getMessageId();
    }

    @Deprecated
    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.messageDefinition.getMessageTemplate());
        String result = mf.format(params);
        log.debug(String.format("OIFErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    @Deprecated
    public String getSystemAction() {
        return this.messageDefinition.getSystemAction();
    }

    @Deprecated
    public String getUserAction() {
        return this.messageDefinition.getUserAction();
    }

    @Override
    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    @Override
    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OIFErrorCode{messageDefinition=" + this.messageDefinition + "}";
    }

    static {
        log = LoggerFactory.getLogger(OCFErrorCode.class);
    }
}

