/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.frameworkservices.gaf.client.rest.GAFRESTClient;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FindRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.RelatedMetadataElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ToDoRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationDetailResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.TranslationListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueListResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.ValidMetadataValueResponse;

public abstract class OpenMetadataClientBase
extends OpenMetadataClient {
    private final GAFRESTClient restClient;
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new GAFRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
    }

    public OpenMetadataClientBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, GAFRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Client Constructor (with REST client)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor (with REST client)");
        this.restClient = restClient;
    }

    private long getEffectiveTimeAsLong(Date effectiveTime) {
        long effectiveTimeLong = 0L;
        if (effectiveTime != null) {
            effectiveTimeLong = effectiveTime.getTime();
        }
        return effectiveTimeLong;
    }

    @Override
    public OpenMetadataElement getMetadataElementByGUID(String userId, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByGUID";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByGUID");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getMetadataElementByGUID");
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementGetRESTCall("getMetadataElementByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    @Override
    public OpenMetadataElement getMetadataElementByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        OpenMetadataElementResponse restResult = this.restClient.callOpenMetadataElementPostRESTCall("getMetadataElementByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    @Override
    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniquePropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataElementGUIDByUniqueName";
        String defaultPropertyName = "qualifiedName";
        String nameParameterName = "uniqueName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/guid-by-unique-name?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataElementGUIDByUniqueName");
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", "getMetadataElementGUIDByUniqueName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(uniqueName);
        requestBody.setNameParameterName("uniqueName");
        if (uniquePropertyName != null) {
            requestBody.setNamePropertyName(uniquePropertyName);
        } else {
            requestBody.setNamePropertyName("qualifiedName");
        }
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataElementGUIDByUniqueName", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getGUID();
    }

    @Override
    public List<OpenMetadataElement> findMetadataElementsWithString(String userId, String searchString, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElementsWithString";
        String searchStringParameterName = "searchString";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-string?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElementsWithString");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findMetadataElementsWithString");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElementsWithString", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelatedMetadataElements";
        String guidParameterName = "elementGUID";
        String allURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/any-type?startingAtEnd={4}&forLineage={5}&forDuplicateProcessing={6}&effectiveTime={7}&startFrom={8}&pageSize={9}";
        String specificURLTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/type/{4}?startingAtEnd={5}&forLineage={6}&forDuplicateProcessing={7}&effectiveTime={8}&startFrom={9}&pageSize={10}";
        this.invalidParameterHandler.validateUserId(userId, "getRelatedMetadataElements");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getRelatedMetadataElements");
        RelatedMetadataElementListResponse restResult = relationshipTypeName == null ? this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", allURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, startingAtEnd, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize) : this.restClient.callRelatedMetadataElementListGetRESTCall("getRelatedMetadataElements", specificURLTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, relationshipTypeName, startingAtEnd, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public List<OpenMetadataElement> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeNames, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(metadataElementTypeName);
        requestBody.setMetadataElementSubtypeName(metadataElementSubtypeNames);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setLimitResultsByStatus(limitResultsByStatus);
        requestBody.setMatchClassifications(matchClassifications);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        OpenMetadataElementsResponse restResult = this.restClient.callOpenMetadataElementsPostRESTCall("findMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findRelationshipsBetweenMetadataElements";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/by-search-specification?forLineage={3}&forDuplicateProcessing={4}&effectiveTime={5}&startFrom={6}&pageSize={7}";
        this.invalidParameterHandler.validateUserId(userId, "findRelationshipsBetweenMetadataElements");
        FindRequestBody requestBody = new FindRequestBody();
        requestBody.setMetadataElementTypeName(relationshipTypeName);
        requestBody.setSearchProperties(searchProperties);
        requestBody.setSequencingProperty(sequencingProperty);
        requestBody.setSequencingOrder(sequencingOrder);
        RelatedMetadataElementsListResponse restResult = this.restClient.callRelatedMetadataElementsListPostRESTCall("findRelationshipsBetweenMetadataElements", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime), startFrom, pageSize);
        return restResult.getElementList();
    }

    @Override
    public RelatedMetadataElements getRelationshipByGUID(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRelationshipByGUID";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/relationship/{3}?forLineage={4}&forDuplicateProcessing={5}&effectiveTime={6}";
        this.invalidParameterHandler.validateUserId(userId, "getRelationshipByGUID");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "getRelationshipByGUID");
        RelatedMetadataElementsResponse restResult = this.restClient.callRelatedMetadataElementGetRESTCall("getRelationshipByGUID", urlTemplate, this.serverName, this.serviceURLMarker, userId, relationshipGUID, forLineage, forDuplicateProcessing, this.getEffectiveTimeAsLong(effectiveTime));
        return restResult.getElement();
    }

    @Override
    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createMetadataElementInStore(userId, null, null, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
    }

    @Override
    public String createMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        String elementTypeParameterName = "metadataElementTypeName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataElementInStore");
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", "createMetadataElementInStore");
        NewMetadataElementRequestBody requestBody = new NewMetadataElementRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(metadataElementTypeName);
        requestBody.setInitialStatus(initialStatus);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setTemplateGUID(templateGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementInStore(userId, null, null, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementStatusInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    @Override
    public void updateMetadataElementStatusInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-status";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementStatusInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementStatusInStore");
        UpdateStatusRequestBody requestBody = new UpdateStatusRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setNewStatus(newElementStatus);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementStatusInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void updateMetadataElementEffectivityInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateMetadataElementEffectivityInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateMetadataElementEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateMetadataElementEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateMetadataElementEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateMetadataElementEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteMetadataElementInStore(userId, null, null, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void deleteMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "deleteMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("deleteMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID);
    }

    @Override
    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.classifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void classifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/new";
        this.invalidParameterHandler.validateUserId(userId, "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "classifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "classifyMetadataElementInStore");
        NewClassificationRequestBody requestBody = new NewClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("classifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.reclassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void reclassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "reclassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "reclassifyMetadataElementInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("reclassifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void updateClassificationEffectivityInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateClassificationEffectivityInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateClassificationEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "updateClassificationEffectivityInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "updateClassificationEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("updateClassificationEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public void declassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.declassifyMetadataElementInStore(userId, null, null, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void declassifyMetadataElementInStore(String userId, String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "declassifyMetadataElementInStore";
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/metadata-elements/{3}/classifications/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "declassifyMetadataElementInStore");
        this.invalidParameterHandler.validateName(classificationName, "classificationName", "declassifyMetadataElementInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callGUIDPostRESTCall("declassifyMetadataElementInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, metadataElementGUID, classificationName);
    }

    @Override
    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createRelatedElementsInStore(userId, null, null, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public String createRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/new";
        this.invalidParameterHandler.validateUserId(userId, "createRelatedElementsInStore");
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", "createRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", "createRelatedElementsInStore");
        NewRelatedElementsRequestBody requestBody = new NewRelatedElementsRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setTypeName(relationshipTypeName);
        requestBody.setMetadataElement1GUID(metadataElement1GUID);
        requestBody.setMetadataElement2GUID(metadataElement2GUID);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setProperties(properties);
        requestBody.setEffectiveTime(effectiveTime);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createRelatedElementsInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsInStore(userId, null, null, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-properties";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsInStore");
        UpdatePropertiesRequestBody requestBody = new UpdatePropertiesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setReplaceProperties(replaceProperties);
        requestBody.setProperties(properties);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public void updateRelatedElementsEffectivityInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelatedElementsEffectivityInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void updateRelatedElementsEffectivityInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/update-effectivity";
        this.invalidParameterHandler.validateUserId(userId, "updateRelatedElementsEffectivityInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "updateRelatedElementsEffectivityInStore");
        UpdateEffectivityDatesRequestBody requestBody = new UpdateEffectivityDatesRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveFrom(effectiveFrom);
        requestBody.setEffectiveTo(effectiveTo);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("updateRelatedElementsEffectivityInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelatedElementsInStore(userId, null, null, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void deleteRelatedElementsInStore(String userId, String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        String guidParameterName = "relationshipGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/related-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteRelatedElementsInStore");
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", "deleteRelatedElementsInStore");
        UpdateRequestBody requestBody = new UpdateRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setForLineage(forLineage);
        requestBody.setForDuplicateProcessing(forDuplicateProcessing);
        requestBody.setEffectiveTime(effectiveTime);
        this.restClient.callVoidPostRESTCall("deleteRelatedElementsInStore", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId, relationshipGUID);
    }

    @Override
    public String initiateGovernanceActionProcess(String userId, String processQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "initiateGovernanceActionProcess";
        String qualifiedNameParameterName = "processQualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-governance-service/users/{2}/governance-action-processes/initiate";
        this.invalidParameterHandler.validateUserId(userId, "initiateGovernanceActionProcess");
        this.invalidParameterHandler.validateName(processQualifiedName, "processQualifiedName", "initiateGovernanceActionProcess");
        GovernanceActionProcessRequestBody requestBody = new GovernanceActionProcessRequestBody();
        requestBody.setProcessQualifiedName(processQualifiedName);
        requestBody.setRequestSourceGUIDs(requestSourceGUIDs);
        requestBody.setActionTargets(actionTargets);
        requestBody.setStartTime(startTime);
        requestBody.setRequestParameters(requestParameters);
        requestBody.setOriginatorServiceName(originatorServiceName);
        requestBody.setOriginatorEngineName(originatorEngineName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("initiateGovernanceActionProcess", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String createIncidentReport(String userId, String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIncidentReport";
        String qualifiedNameParameterName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/incident-reports";
        this.invalidParameterHandler.validateUserId(userId, "createIncidentReport");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createIncidentReport");
        IncidentReportRequestBody requestBody = new IncidentReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDomainIdentifier(domainIdentifier);
        requestBody.setBackground(background);
        requestBody.setImpactedResources(impactedResources);
        requestBody.setPreviousIncidents(previousIncidents);
        requestBody.setIncidentClassifiers(incidentClassifiers);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setOriginatorGUID(originatorGUID);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createIncidentReport", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    @Override
    public String openToDo(String userId, String qualifiedName, String title, String instructions, String category, int priority, Date dueDate, Map<String, String> additionalProperties, String assignTo, String causeGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String qualifiedNamePropertyName = "qualifiedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/to-dos";
        this.invalidParameterHandler.validateUserId(userId, "openToDo");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "openToDo");
        ToDoRequestBody requestBody = new ToDoRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setTitle(title);
        requestBody.setInstructions(instructions);
        requestBody.setCategory(category);
        requestBody.setPriority(priority);
        requestBody.setDueDate(dueDate);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setAssignToQualifiedName(assignTo);
        requestBody.setCauseGUID(causeGUID);
        requestBody.setActionTargets(actionTargets);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("openToDo", urlTemplate, requestBody, this.serverName, this.serviceURLMarker, userId);
        return restResult.getGUID();
    }

    public String openToDo(String userId, String toDoQualifiedName, String title, String instructions, int priority, Date dueDate, String assignTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String todoTypeName = "ToDo";
        String personRoleTypeName = "PersonRole";
        String actionAssignmentTypeName = "ActionAssignment";
        String qualifiedNamePropertyName = "qualifiedName";
        String titlePropertyName = "name";
        String instructionsPropertyName = "description";
        String priorityPropertyName = "priority";
        String dueDatePropertyName = "dueTime";
        String statusPropertyName = "status";
        String statusPropertyTypeName = "ToDoStatus";
        String openEnumPropertyValue = "Open";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignTo";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignTo, "assignTo", "openToDo");
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
        primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitiveTypePropertyValue.setPrimitiveValue(assignTo);
        primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty("qualifiedName");
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue(primitiveTypePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        List<OpenMetadataElement> personRoleMatches = this.findMetadataElements(userId, "PersonRole", null, searchProperties, null, null, null, null, false, false, new Date(), 0, 0);
        if (personRoleMatches == null || personRoleMatches.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo"), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        if (personRoleMatches.size() > 1) {
            ArrayList<String> matchingGUIDs = new ArrayList<String>();
            for (OpenMetadataElement element : personRoleMatches) {
                if (element == null) continue;
                matchingGUIDs.add(element.getElementGUID());
            }
            throw new InvalidParameterException(GAFErrorCode.DUPLICATE_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo", ((Object)matchingGUIDs).toString()), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        OpenMetadataElement personRoleElement = personRoleMatches.get(0);
        String personRoleGUID = null;
        if (personRoleElement != null && personRoleElement.getElementGUID() != null) {
            personRoleGUID = personRoleElement.getElementGUID();
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", toDoQualifiedName);
        if (title != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", title);
        }
        if (instructions != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", "description");
        }
        if (dueDate != null) {
            properties = this.propertyHelper.addDateProperty(properties, "dueTime", dueDate);
        }
        properties = this.propertyHelper.addIntProperty(properties, "priority", priority);
        properties = this.propertyHelper.addEnumProperty(properties, "status", "ToDoStatus", "Open");
        String todoGUID = this.createMetadataElementInStore(userId, "ToDo", ElementStatus.ACTIVE, null, null, properties, null);
        this.createRelatedElementsInStore(userId, "ActionAssignment", personRoleGUID, todoGUID, false, false, null, null, null, new Date());
        return todoGUID;
    }

    @Override
    public void setTranslation(String userId, String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTranslation";
        String elementGUIDParameterName = "elementGUID";
        String translationDetailParameterName = "translationDetail";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/set-translation/{3}";
        this.invalidParameterHandler.validateUserId(userId, "setTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "setTranslation");
        this.invalidParameterHandler.validateObject(translationDetail, "translationDetail", "setTranslation");
        this.restClient.callVoidPostRESTCall("setTranslation", urlTemplate, translationDetail, this.serverName, this.serviceURLMarker, userId, elementGUID);
    }

    @Override
    public void clearTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/clear-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "clearTranslation");
        this.invalidParameterHandler.validateName(language, "language", "clearTranslation");
        this.restClient.callVoidPostRESTCall("clearTranslation", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
    }

    @Override
    public TranslationDetail getTranslation(String userId, String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslation";
        String elementGUIDParameterName = "elementGUID";
        String languageParameterName = "language";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translation/{3}?language={4}&locale={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslation");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslation");
        this.invalidParameterHandler.validateName(language, "language", "getTranslation");
        TranslationDetailResponse response = this.restClient.callTranslationDetailGetRESTCall("getTranslation", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, language, locale);
        return response.getElement();
    }

    @Override
    public List<TranslationDetail> getTranslations(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTranslations";
        String elementGUIDParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/multi-language/get-translations/{3}?startFrom={4}&pageSize={5}";
        this.invalidParameterHandler.validateUserId(userId, "getTranslations");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getTranslations");
        TranslationListResponse response = this.restClient.callTranslationListGetRESTCall("getTranslations", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, elementGUID, startFrom, pageSize);
        return response.getElementList();
    }

    @Override
    public void setUpValidMetadataValue(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-value/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataValue");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataValue", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, typeName);
    }

    @Override
    public void setUpValidMetadataMapName(String userId, String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-name/{3}?typeName={4}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapName");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapName", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, typeName);
    }

    @Override
    public void setUpValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setUpValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String propertiesParameterName = "validMetadataValue";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/setup-map-value/{3}/{4}?typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "setUpValidMetadataMapValue");
        this.invalidParameterHandler.validateObject(validMetadataValue, "validMetadataValue", "setUpValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("setUpValidMetadataMapValue", urlTemplate, validMetadataValue, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, typeName);
    }

    @Override
    public void clearValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
    }

    @Override
    public void clearValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapName");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapName", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
    }

    @Override
    public void clearValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/clear-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "clearValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "clearValidMetadataMapValue");
        this.restClient.callVoidPostRESTCall("clearValidMetadataMapValue", urlTemplate, new NullRequestBody(), this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName);
    }

    @Override
    public boolean validateMetadataValue(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-value/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public boolean validateMetadataMapName(String userId, String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-name/{3}?actualValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapName");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public boolean validateMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "validateMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/validate-map-value/{3}/{4}?actualValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "validateMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "validateMetadataMapValue");
        BooleanResponse response = this.restClient.callBooleanGetRESTCall("validateMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, actualValue, typeName);
        return response.getFlag();
    }

    @Override
    public ValidMetadataValue getValidMetadataValue(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValue";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-value/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public ValidMetadataValue getValidMetadataMapName(String userId, String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapName";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-name/{3}?preferredValue={4}&typeName={5}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapName");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapName");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapName", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public ValidMetadataValue getValidMetadataMapValue(String userId, String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataMapValue";
        String propertyNameParameterName = "propertyName";
        String mapNameParameterName = "mapName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-map-value/{3}/{4}?preferredValue={5}&typeName={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataMapValue");
        this.invalidParameterHandler.validateName(mapName, "mapName", "getValidMetadataMapValue");
        ValidMetadataValueResponse response = this.restClient.callValidMetadataValueGetRESTCall("getValidMetadataMapValue", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, mapName, preferredValue, typeName);
        return response.getElement();
    }

    @Override
    public List<ValidMetadataValueDetail> getValidMetadataValues(String userId, String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getValidMetadataValues";
        String propertyNameParameterName = "propertyName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-metadata-store/users/{2}/valid-metadata-values/get-valid-metadata-values/{3}?typeName={4}&startFrom={5}&pageSize={6}";
        this.invalidParameterHandler.validateUserId(userId, "getValidMetadataValues");
        this.invalidParameterHandler.validateName(propertyName, "propertyName", "getValidMetadataValues");
        ValidMetadataValueListResponse response = this.restClient.callValidMetadataValueListGetRESTCall("getValidMetadataValues", urlTemplate, this.serverName, this.serviceURLMarker, userId, propertyName, typeName, startFrom, pageSize);
        return response.getElementList();
    }
}

