/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.APIOperations;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedDeployedAPIOperation;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.APIOperationResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.APIOperationsResponse;

public class ConnectedAPIOperations
extends APIOperations {
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String schemaGUID;
    private int maxCacheSize;
    private OCFRESTClient restClient;
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    ConnectedAPIOperations(String serviceName, String serverName, String userId, String omasServerURL, String schemaGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.schemaGUID = schemaGUID;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedAPIOperations(ConnectedAPIOperations template) {
        super(template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.schemaGUID = template.schemaGUID;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    @Override
    protected APIOperations cloneIterator() {
        return new ConnectedAPIOperations(this);
    }

    @Override
    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "APIOperations.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/apis/{3}/api-operations?elementStart={4}&maxElements={5}";
        try {
            APIOperationsResponse restResult = this.restClient.callOCFAPIOperationsGetRESTCall("APIOperations.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/apis/{3}/api-operations?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.schemaGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException(restResult);
            List<APIOperationResponse> apiOperations = restResult.getList();
            if (apiOperations == null || apiOperations.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (APIOperationResponse apiOperation : apiOperations) {
                if (apiOperation == null) continue;
                resultList.add(new ConnectedDeployedAPIOperation(apiOperation.getAPIOperation(), apiOperation.getHeaderAttributeCount(), apiOperation.getRequestAttributeCount(), apiOperation.getResponseAttributeCount(), this.serviceName, this.serverName, this.omasServerURL, this.userId, this.maxCacheSize, this.restClient));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException(error, "APIOperations.getCachedList", this.serverName, this.omasServerURL);
        }
        return null;
    }
}

