/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.APISchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetLineage;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedCertifications;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedConnections;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedDeployedAPISchemaType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedExternalIdentifiers;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedExternalReferences;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedFeedback;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedLicenses;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedLocations;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedNestedSchemaType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedNoteLogs;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedRelatedAssets;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedRelatedMediaReferences;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetResponse;

public class ConnectedAssetUniverse
extends AssetUniverse {
    private final int MAX_CACHE_SIZE = 100;
    private static final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    private ConnectedAssetUniverse(AssetResponse assetResponse, OCFRESTClient restClient, String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        super(assetResponse.getAsset());
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL);
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, omasServerURL, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String omasServerURL, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL, localServerUserId, localServerPassword);
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, omasServerURL, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, OCFRESTClient restClient) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, omasServerURL, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL);
        AssetResponse assetResponse = ConnectedAssetUniverse.getConnectedAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID, connectionGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, omasServerURL, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String omasServerURL, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL, localServerUserId, localServerPassword);
        AssetResponse assetResponse = ConnectedAssetUniverse.getConnectedAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID, connectionGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, omasServerURL, userId, assetGUID);
    }

    private void processAssetResponse(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, OCFRESTClient restClient, AssetResponse assetResponse) {
        if (assetResponse.getExternalIdentifierCount() > 0) {
            this.externalIdentifiers = new ConnectedExternalIdentifiers(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getExternalIdentifierCount(), 100, restClient);
        }
        if (assetResponse.getRelatedMediaReferenceCount() > 0) {
            this.relatedMediaReferences = new ConnectedRelatedMediaReferences(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getRelatedMediaReferenceCount(), 100, restClient);
        }
        if (assetResponse.getNoteLogsCount() > 0) {
            this.noteLogs = new ConnectedNoteLogs(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getNoteLogsCount(), 100, restClient);
        }
        if (assetResponse.getExternalReferencesCount() > 0) {
            this.externalReferences = new ConnectedExternalReferences(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getExternalReferencesCount(), 100, restClient);
        }
        if (assetResponse.getConnectionCount() > 0) {
            this.connections = new ConnectedConnections(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getConnectionCount(), 100, restClient);
        }
        if (assetResponse.getLicenseCount() > 0) {
            this.licenses = new ConnectedLicenses(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getLicenseCount(), 100, restClient);
        }
        if (assetResponse.getCertificationCount() > 0) {
            this.certifications = new ConnectedCertifications(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getCertificationCount(), 100, restClient);
        }
        this.feedback = new ConnectedFeedback(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getCommentCount(), assetResponse.getLikeCount(), assetResponse.getRatingsCount(), assetResponse.getInformalTagCount(), 100, restClient);
        if (assetResponse.getKnownLocationsCount() > 0) {
            this.knownLocations = new ConnectedLocations(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getKnownLocationsCount(), 100, restClient);
        }
        this.lineage = new ConnectedAssetLineage(serviceName, remoteServerName, userId, omasServerURL, assetGUID, 100, restClient);
        if (assetResponse.getRelatedAssetCount() > 0) {
            this.relatedAssets = new ConnectedRelatedAssets(serviceName, remoteServerName, userId, omasServerURL, assetGUID, assetResponse.getRelatedAssetCount(), 100, restClient);
        }
        if (assetResponse.getSchemaType() != null) {
            this.schema = this.getSchemaType(serviceName, remoteServerName, omasServerURL, userId, assetResponse.getSchemaType(), restClient);
        }
    }

    private static AssetResponse getConnectedAssetSummary(String serviceName, String remoteServerName, String omasServerURL, OCFRESTClient restClient, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectedAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}";
        invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, remoteServerName, "getConnectedAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getConnectedAssetSummary", omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}", remoteServerName, serviceName, userId, assetGUID, connectionGUID);
            restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            restExceptionHandler.detectAndThrowPropertyServerException(restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "getConnectedAssetSummary", remoteServerName, omasServerURL);
        }
        return restResult;
    }

    private static AssetResponse getAssetSummary(String serviceName, String remoteServerName, String omasServerURL, OCFRESTClient restClient, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}";
        invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, remoteServerName, "getAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getAssetSummary", omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}", remoteServerName, serviceName, userId, assetGUID);
            restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            restExceptionHandler.detectAndThrowPropertyServerException(restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "getAssetSummary", remoteServerName, omasServerURL);
        }
        return restResult;
    }

    private SchemaType getSchemaType(String serviceName, String remoteServerName, String omasServerURL, String userId, SchemaType bean, OCFRESTClient restClient) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof ComplexSchemaType) {
            return new ConnectedNestedSchemaType((ComplexSchemaType)bean, serviceName, remoteServerName, omasServerURL, userId, 100, restClient);
        }
        if (bean instanceof APISchemaType) {
            return new ConnectedDeployedAPISchemaType((APISchemaType)bean, serviceName, remoteServerName, omasServerURL, userId, 100, restClient);
        }
        return bean;
    }
}

