/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.SchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;

public class ConnectedSchemaAttributes
extends SchemaAttributes {
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String schemaGUID;
    private int maxCacheSize;
    private OCFRESTClient restClient;
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    ConnectedSchemaAttributes(String serviceName, String serverName, String userId, String omasServerURL, String schemaGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.schemaGUID = schemaGUID;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedSchemaAttributes(ConnectedSchemaAttributes template) {
        super(template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.schemaGUID = template.schemaGUID;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    @Override
    protected SchemaAttributes cloneIterator() {
        return new ConnectedSchemaAttributes(this);
    }

    @Override
    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "SchemaAttributes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/{3}/schema-attributes?elementStart={4}&maxElements={5}";
        try {
            SchemaAttributesResponse restResult = this.restClient.callOCFSchemaAttributesGetRESTCall("SchemaAttributes.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/{3}/schema-attributes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.schemaGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException(restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException(restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException(restResult);
            List<SchemaAttribute> schemaAttributes = restResult.getList();
            if (schemaAttributes == null || schemaAttributes.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                resultList.add(new SchemaAttribute(schemaAttribute));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException(error, "SchemaAttributes.getCachedList", this.serverName, this.omasServerURL);
        }
        return null;
    }
}

