/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

class JdkClientHttpResponse
implements ClientHttpResponse {
    private static final Pattern SAME_SITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");
    private final HttpResponse<Flow.Publisher<List<ByteBuffer>>> response;
    private final DataBufferFactory bufferFactory;
    private final HttpHeaders headers;

    public JdkClientHttpResponse(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response, DataBufferFactory bufferFactory) {
        this.response = response;
        this.bufferFactory = bufferFactory;
        this.headers = JdkClientHttpResponse.adaptHeaders(response);
    }

    private static HttpHeaders adaptHeaders(HttpResponse<Flow.Publisher<List<ByteBuffer>>> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ENGLISH);
        MultiValueMap<String, String> multiValueMap = CollectionUtils.toMultiValueMap(map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders(multiValueMap);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.statusCode());
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.response.headers().allValues("Set-Cookie").stream().flatMap(header -> {
            Matcher matcher = SAME_SITE_PATTERN.matcher((CharSequence)header);
            String sameSite = matcher.matches() ? matcher.group(1) : null;
            return HttpCookie.parse(header).stream().map(cookie -> this.toResponseCookie((HttpCookie)cookie, sameSite));
        }).collect(LinkedMultiValueMap::new, (cookies, cookie) -> cookies.add(cookie.getName(), cookie), MultiValueMapAdapter::addAll);
    }

    private ResponseCookie toResponseCookie(HttpCookie cookie, @Nullable String sameSite) {
        return ResponseCookie.from(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly()).maxAge(cookie.getMaxAge()).path(cookie.getPath()).secure(cookie.getSecure()).sameSite(sameSite).build();
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return JdkFlowAdapter.flowPublisherToFlux(this.response.body()).flatMapIterable(Function.identity()).map(this.bufferFactory::wrap).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
    }
}

