/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataManagerErrorCode implements ExceptionMessageSet
{
    BAD_PARAMETER(400, "OMAS-DATA-MANAGER-400-006", "At least one of the properties supplied for a new relationship of type {0} are invalid.  The {1} exception was returned with error message: {2}", "The system is unable to create the requested relationship because it can not parse the properties.", "Correct the caller's logic so that the properties passed are correctly formatted and retry the request."),
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-MANAGER-404-001", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to an open metadata repository.", "Check that the server where the Data Manager OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    NULL_LISTENER(500, "OMAS-DATA-MANAGER-500-001", "A null topic listener has been passed by user {0} on method {1}", "There is a coding error in the caller to the Data Manager OMAS.", "Correct the caller logic and retry the request."),
    UNABLE_TO_SEND_EVENT(500, "OMAS-DATA-MANAGER-500-004", "An unexpected exception occurred when sending an event through connector {0} to the Data Manager OMAS out topic.  The failing event was {1}, the exception was {2} with message {2}", "The system has issued a call to an open metadata access service REST API in a remote server and has received a null response.", "Look for errors in the remote server's audit log and console to understand and correct the source of the error.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private DataManagerErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    @Override
    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    @Override
    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

