/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.APIParameterListType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class APIParameterListElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private APIParameterListProperties properties = null;
    private APIParameterListType parameterListType = null;
    private int parameterCount = 0;

    public APIParameterListElement() {
    }

    public APIParameterListElement(APIParameterListElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.parameterListType = template.getParameterListType();
            this.parameterCount = template.getParameterCount();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public APIParameterListProperties getProperties() {
        return this.properties;
    }

    public void setProperties(APIParameterListProperties properties) {
        this.properties = properties;
    }

    public APIParameterListType getParameterListType() {
        return this.parameterListType;
    }

    public void setParameterListType(APIParameterListType parameterListType) {
        this.parameterListType = parameterListType;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void setParameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    public String toString() {
        return "APIParameterListElement{elementHeader=" + this.elementHeader + ", properties=" + this.properties + ", parameterListType=" + this.parameterListType + ", parameterCount=" + this.parameterCount + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        APIParameterListElement that = (APIParameterListElement)objectToCompare;
        return this.parameterCount == that.parameterCount && Objects.equals(this.properties, that.properties) && Objects.equals((Object)this.parameterListType, (Object)that.parameterListType) && Objects.equals(this.elementHeader, that.elementHeader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.elementHeader, this.properties, this.parameterListType, this.parameterCount});
    }
}

