/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DataFileProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.FileFolderProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DatabaseProperties.class, name="DatabaseProperties"), @JsonSubTypes.Type(value=DataFileProperties.class, name="DataFileProperties"), @JsonSubTypes.Type(value=FileFolderProperties.class, name="FileFolderProperties")})
public class DataStoreProperties
extends AssetProperties {
    private String deployedImplementationType = null;
    private String pathName = null;
    private Date createTime = null;
    private Date modifiedTime = null;
    private String encodingType = null;
    private String encodingLanguage = null;
    private String encodingDescription = null;
    private Map<String, String> encodingProperties = null;

    public DataStoreProperties() {
    }

    public DataStoreProperties(DataStoreProperties template) {
        super(template);
        if (template != null) {
            this.deployedImplementationType = template.getDeployedImplementationType();
            this.pathName = template.getPathName();
            this.createTime = template.getCreateTime();
            this.modifiedTime = template.getModifiedTime();
            this.encodingType = template.getEncodingType();
            this.encodingLanguage = template.getEncodingLanguage();
            this.encodingDescription = template.getEncodingDescription();
            this.encodingProperties = template.getEncodingProperties();
        }
    }

    public DataStoreProperties(AssetProperties template) {
        super(template);
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public void setDeployedImplementationType(String deployedImplementationType) {
        this.deployedImplementationType = deployedImplementationType;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingLanguage() {
        return this.encodingLanguage;
    }

    public void setEncodingLanguage(String encodingLanguage) {
        this.encodingLanguage = encodingLanguage;
    }

    public String getEncodingDescription() {
        return this.encodingDescription;
    }

    public void setEncodingDescription(String encodingDescription) {
        this.encodingDescription = encodingDescription;
    }

    public Map<String, String> getEncodingProperties() {
        if (this.encodingProperties == null) {
            return null;
        }
        if (this.encodingProperties.isEmpty()) {
            return null;
        }
        return this.encodingProperties;
    }

    public void setEncodingProperties(Map<String, String> encodingProperties) {
        this.encodingProperties = encodingProperties;
    }

    @Override
    public String toString() {
        return "DataStoreProperties{name='" + this.getName() + "', versionIdentifier='" + this.getVersionIdentifier() + "', description='" + this.getDescription() + "', deployedImplementationType='" + this.deployedImplementationType + "', pathName='" + this.pathName + "', createTime=" + this.createTime + ", modifiedTime=" + this.modifiedTime + ", encodingType='" + this.encodingType + "', encodingLanguage='" + this.encodingLanguage + "', encodingDescription='" + this.encodingDescription + "', encodingProperties=" + this.encodingProperties + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof DataStoreProperties)) {
            return false;
        }
        DataStoreProperties that = (DataStoreProperties)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.deployedImplementationType, that.deployedImplementationType) && Objects.equals(this.pathName, that.pathName) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.modifiedTime, that.modifiedTime) && Objects.equals(this.encodingType, that.encodingType) && Objects.equals(this.encodingLanguage, that.encodingLanguage) && Objects.equals(this.encodingDescription, that.encodingDescription) && Objects.equals(this.encodingProperties, that.encodingProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deployedImplementationType, this.pathName, this.createTime, this.modifiedTime, this.encodingType, this.encodingLanguage, this.encodingDescription, this.encodingProperties);
    }
}

