/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum LocalRepositoryMode {
    UNCLASSIFIED(0, "Unclassified", "The mode of the repository is unknown."),
    NO_REPOSITORY(1, "No Repository", "The server is running without a local repository."),
    METADATA_CACHE(2, "Metadata Cache", "This local repository is read only and is able to act as a cache for metadata but not to master new values."),
    REPOSITORY_PROXY(3, "Repository Proxy", "This local repository is actually a proxy to third party metadata repository. It is restricted to the capability of the third party repository."),
    OPEN_METADATA_NATIVE(4, "Open Metadata Native", "This local repository is a plugin repository that is part of Egeria and has been built specifically for open metadata and as such is able to dynamically absorb new types of metadata."),
    PLUGIN_REPOSITORY(5, "Plugin Repository", "This local repository has been built by a third party as a plugin repository.");

    private final int ordinal;
    private final String name;
    private final String description;

    private LocalRepositoryMode(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "LocalRepositoryMode{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

