/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

public enum ServerTypeClassification {
    OMAG_SERVER("Open Metadata and Governance (OMAG) Server", "Generic name for a server that runs on the OMAG Platform.", null, "https://egeria-project.org/concepts/omag-server/"),
    COHORT_MEMBER("Cohort Member", "OMAG Server that is capable of joining one or more open metadata repository cohorts.", OMAG_SERVER, "https://egeria-project.org/concepts/cohort-member/"),
    METADATA_ACCESS_SERVER("Metadata Access Server", "Server that provides specialist APIs for accessing and storing metadata inopen metadata repositories connected through one or more open metadata repository cohorts.", COHORT_MEMBER, "https://egeria-project.org/concepts/metadata-access-server/"),
    METADATA_ACCESS_STORE("Metadata Access Store", "Server that is a metadata access server with its own native open metadata repository.", METADATA_ACCESS_SERVER, "https://egeria-project.org/concepts/metadata-access-store/"),
    METADATA_ACCESS_POINT("Metadata Access Point", "Server that is a metadata access server without its own native open metadata repository so all metadata access is remote.", METADATA_ACCESS_SERVER, "https://egeria-project.org/concepts/metadata-access-point/"),
    REPOSITORY_PROXY("Repository Proxy", "Hosting environment for a repository connector acting as an adapter to a third party metadata server.", COHORT_MEMBER, "https://egeria-project.org/concepts/repository-proxy/"),
    CONFORMANCE_SERVER("Conformance Test Server", "Server that hosts the conformance test suite.", COHORT_MEMBER, "https://egeria-project.org/concepts/conformance-test-server/"),
    GOVERNANCE_SERVER("Governance Server", "Server that hosts integration, management or governance function.", OMAG_SERVER, "https://egeria-project.org/concepts/governance-server/"),
    INTEGRATION_DAEMON("Integration Daemon", "Governance server that hosts connectors that are exchanging metadata with third party technology.  These servers typically do not have their own API which is why they are called daemons.", GOVERNANCE_SERVER, "https://egeria-project.org/concepts/integration-daemon/"),
    ENGINE_HOST("Engine Host Server", "Governance server that hosts the Open Metadata Engine Services (OMES) that is managing workloads for an aspect of governance.", GOVERNANCE_SERVER, "https://egeria-project.org/concepts/engine-host/"),
    LINEAGE_WAREHOUSE("Lineage Warehouse", "Server that manages a warehouse of lineage information.", GOVERNANCE_SERVER, "https://egeria-project.org/concepts/lineage-warehouse/"),
    DATA_ENGINE_PROXY("Data Engine Proxy", "Server that manages the extraction of metadata from a single data engine.", GOVERNANCE_SERVER, "https://egeria-project.org/concepts/data-engine-proxy/"),
    VIEW_SERVER("View Server", "A View Server is an OMAG Server that hosts the view services to support a User Interface.", OMAG_SERVER, "https://egeria-project.org/concepts/view-server/");

    private final String serverTypeName;
    private final String serverTypeDescription;
    private final ServerTypeClassification superType;
    private final String serverTypeWiki;

    private ServerTypeClassification(String serverTypeName, String serverTypeDescription, ServerTypeClassification superType, String serverTypeWiki) {
        this.serverTypeName = serverTypeName;
        this.serverTypeDescription = serverTypeDescription;
        this.superType = superType;
        this.serverTypeWiki = serverTypeWiki;
    }

    public String getServerTypeName() {
        return this.serverTypeName;
    }

    public String getServerTypeDescription() {
        return this.serverTypeDescription;
    }

    public ServerTypeClassification getSuperType() {
        return this.superType;
    }

    public String getServerTypeWiki() {
        return this.serverTypeWiki;
    }
}

