/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ViewServiceRequestBody
extends OMAGServerClientConfig {
    private Map<String, Object> viewServiceOptions = null;
    private List<ResourceEndpointConfig> resourceEndpoints;

    public ViewServiceRequestBody() {
    }

    public ViewServiceRequestBody(ViewServiceRequestBody template) {
        super(template);
        if (template != null) {
            this.viewServiceOptions = template.getViewServiceOptions();
            this.resourceEndpoints = template.getResourceEndpoints();
        }
    }

    public Map<String, Object> getViewServiceOptions() {
        if (this.viewServiceOptions == null) {
            return null;
        }
        if (this.viewServiceOptions.isEmpty()) {
            return null;
        }
        return this.viewServiceOptions;
    }

    public void setViewServiceOptions(Map<String, Object> viewServiceOptions) {
        this.viewServiceOptions = viewServiceOptions;
    }

    public List<ResourceEndpointConfig> getResourceEndpoints() {
        return this.resourceEndpoints;
    }

    public void setResourceEndpoints(List<ResourceEndpointConfig> resourceEndpoints) {
        this.resourceEndpoints = resourceEndpoints;
    }

    @Override
    public String toString() {
        return "ViewServiceRequestBody{viewServiceOptions=" + this.viewServiceOptions + ", resourceEndpoints=" + this.resourceEndpoints + ", OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + "', OMAGServerName='" + this.getOMAGServerName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ViewServiceRequestBody that = (ViewServiceRequestBody)objectToCompare;
        return Objects.equals(this.viewServiceOptions, that.viewServiceOptions) && Objects.equals(this.resourceEndpoints, that.resourceEndpoints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.viewServiceOptions, this.resourceEndpoints);
    }
}

