/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassificationHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementClassification
extends ElementClassificationHeader {
    private String classificationName = null;
    private Map<String, Object> classificationProperties = null;

    public ElementClassification() {
    }

    public ElementClassification(ElementClassification template) {
        super(template);
        if (template != null) {
            this.classificationName = template.getClassificationName();
            this.classificationProperties = template.getClassificationProperties();
        }
    }

    public ElementClassification(ElementClassificationHeader template) {
        super(template);
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public String getClassificationName() {
        return this.classificationName;
    }

    public void setClassificationProperties(Map<String, Object> classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public Map<String, Object> getClassificationProperties() {
        if (this.classificationProperties == null) {
            return null;
        }
        if (this.classificationProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.classificationProperties);
    }

    @Override
    public String toString() {
        return "ElementClassification{classificationName='" + this.classificationName + "', classificationProperties=" + this.classificationProperties + ", classificationOrigin=" + this.getClassificationOrigin() + ", classificationOriginGUID='" + this.getClassificationOriginGUID() + "', status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ElementClassification that = (ElementClassification)objectToCompare;
        return Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.classificationProperties, that.classificationProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationName, this.classificationProperties);
    }
}

