/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CommentType implements OpenMetadataEnum
{
    STANDARD_COMMENT(0, "4bbcf72c-4c88-482b-8331-07422542d5c0", "Comment", "General comment about the element.", true),
    QUESTION(1, "e0f0bb6d-ebc2-4d9d-8a76-95d26cd67b22", "Question", "Asks a question to the people owning, managing or using the element.", false),
    ANSWER(2, "ed115faa-aefc-4328-a196-1e0336d3ff2b", "Answer", "Answers a question (posted as a reply to the question).", false),
    SUGGESTION(3, "ae22e098-29e3-46d5-a733-7c411276dc5d", "Suggestion", "Provides a suggestion on how to improve the element or its properties and description.", false),
    USAGE_EXPERIENCE(4, "072f1357-f9fc-45a1-8c9d-27ee400ad2b2", "Experience", "Describes situations where this asset has been used and related hints and tips.", false),
    OTHER(99, "dea55b37-ba37-4aff-a193-424a67b99111", "Other", "Unknown comment type.", false);

    private static final String ENUM_TYPE_GUID = "06d5032e-192a-4f77-ade1-a4b97926e867";
    private static final String ENUM_TYPE_NAME = "CommentType";
    private static final String ENUM_DESCRIPTION = "Defines the sequential order in which bytes are arranged into larger numerical values when stored in memory or when transmitted over digital links.";
    private static final String ENUM_DESCRIPTION_GUID = "5e8e769a-9c8b-4a84-9006-53c49d6efc72";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/1/0150-Feedback/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private CommentType(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.COMMENT_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.COMMENT_TYPE.name, null);
    }

    public String toString() {
        return "CommentType{commentType='" + this.name + "}";
    }
}

