/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum EngineActionStatus implements OpenMetadataEnum
{
    REQUESTED("12daebe5-544c-4968-b5f1-583f52ba7f25", 0, "Requested", "The engine action has been created and is pending.", true),
    APPROVED("623a7b7a-1f5a-403b-b437-e60e66ffea59", 1, "Approved", "The engine action is approved to run.  This means that the mandatory guards have been satisfied.", false),
    WAITING("236c4a55-030b-4e78-ab41-ba54921bb11a", 2, "Waiting", "The engine action is waiting for its start time or the right conditions to run.", false),
    ACTIVATING("0f805c52-f05a-44ac-b785-cc705285794a", 3, "Activating", "The governance service for the engine action is being initialized in the governance engine.", false),
    IN_PROGRESS("c0568205-7adc-4104-a627-7d584a0cb60b", 4, "In Progress", "The governance engine is running the associated governance service for the engine action.", false),
    ACTIONED("3bc841d3-8e51-475c-9283-ee9c8b7e8670", 10, "Actioned", "The governance service for the engine action has successfully completed processing.", false),
    INVALID("6a493851-c089-45a8-877f-c3e98d863c52", 11, "Invalid", "The engine action has not been run because it is not appropriate (for example, a false positive).", false),
    IGNORED("5e7c9514-b303-4710-8869-af30b8e10140", 12, "Ignored", "The engine action has not been run because a different engine action was chosen.", false),
    FAILED("848d072a-a497-49e9-96c4-af61d3ffbebb", 13, "Failed", "The governance service for the engine action failed to execute.", false),
    CANCELLED("80ee5577-a0eb-4c18-8b12-0d4f5606851a", 14, "Cancelled", "The engine action was cancelled by an external caller.", false),
    OTHER("1e67023c-4ae4-4f69-b16e-b5e0290641dc", 99, "Other", "Undefined or unknown engine action status.", false);

    private static final String ENUM_TYPE_GUID = "a6e698b0-a4f7-4a39-8c80-db0bb0f972e";
    private static final String ENUM_TYPE_NAME = "EngineActionStatus";
    private static final String ENUM_DESCRIPTION = "Defines the current execution status of an engine action.";
    private static final String ENUM_DESCRIPTION_GUID = "eb7bba16-b2a0-4e7d-b249-f0be30a50171";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0463-Engine-Actions/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private EngineActionStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.ACTION_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.ACTION_STATUS.name, null);
    }

    public String toString() {
        return "EngineActionStatus{" + this.name + "}";
    }
}

