/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum DeployedImplementationType {
    DATA_ASSET("Data Asset", null, OpenMetadataType.ASSET.typeName, null, "A collection of data, either at rest or in motion.", "https://egeria-project.org/concepts/asset/"),
    FILE("File", DATA_ASSET, OpenMetadataType.DATA_FILE.typeName, null, OpenMetadataType.DATA_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    PROGRAM_FILE("Program File", FILE, OpenMetadataType.DATA_FILE.typeName, null, "A file containing program logic.", "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    DATA_FILE("Data File", FILE, OpenMetadataType.DATA_FILE.typeName, null, "A file containing data.  This may be structured data, text or some form or media file.", "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    CSV_FILE("CSV Data File", DATA_FILE, OpenMetadataType.CSV_FILE.typeName, null, OpenMetadataType.CSV_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    AVRO_FILE("Avro Data File", DATA_FILE, OpenMetadataType.AVRO_FILE.typeName, null, OpenMetadataType.AVRO_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    JSON_FILE("JSON Data File", DATA_FILE, OpenMetadataType.JSON_FILE.typeName, null, OpenMetadataType.JSON_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    PARQUET_FILE("Parquet Data File", DATA_FILE, OpenMetadataType.PARQUET_FILE.typeName, null, OpenMetadataType.PARQUET_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    SPREADSHEET_FILE("Spreadsheet Data File", DATA_FILE, OpenMetadataType.SPREADSHEET_FILE.typeName, null, OpenMetadataType.SPREADSHEET_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    XML_FILE("XML Data File", DATA_FILE, OpenMetadataType.XML_FILE.typeName, null, OpenMetadataType.XML_FILE.description, "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    DOCUMENT("Document File", DATA_FILE, OpenMetadataType.DOCUMENT.typeName, null, OpenMetadataType.DOCUMENT.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    AUDIO_DATA_FILE("Audio Data File", DATA_FILE, OpenMetadataType.AUDIO_FILE.typeName, null, OpenMetadataType.AUDIO_FILE.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    VIDEO_DATA_FILE("Video Data File", DATA_FILE, OpenMetadataType.VIDEO_FILE.typeName, null, OpenMetadataType.VIDEO_FILE.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    THREE_D_IMAGE_DATA_FILE("3D Image Data File", DATA_FILE, OpenMetadataType.THREE_D_IMAGE_FILE.typeName, null, OpenMetadataType.THREE_D_IMAGE_FILE.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    RASTER_DATA_FILE("Raster Data File", DATA_FILE, OpenMetadataType.RASTER_FILE.typeName, null, OpenMetadataType.RASTER_FILE.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    VECTOR_DATA_FILE("Vector Data File", DATA_FILE, OpenMetadataType.VECTOR_FILE.typeName, null, OpenMetadataType.VECTOR_FILE.description, "https://egeria-project.org/types/2/0221-Document-Stores/"),
    SOURCE_CODE_FILE("Source Code File", PROGRAM_FILE, OpenMetadataType.SOURCE_CODE_FILE.typeName, null, OpenMetadataType.SOURCE_CODE_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    BUILD_FILE("Build Instruction File", PROGRAM_FILE, OpenMetadataType.BUILD_INSTRUCTION_FILE.typeName, null, OpenMetadataType.BUILD_INSTRUCTION_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    EXECUTABLE_FILE("Executable File", PROGRAM_FILE, OpenMetadataType.EXECUTABLE_FILE.typeName, null, OpenMetadataType.EXECUTABLE_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    SCRIPT_FILE("Script File", PROGRAM_FILE, OpenMetadataType.SCRIPT_FILE.typeName, null, OpenMetadataType.SCRIPT_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    PROPERTIES_FILE("Properties File", PROGRAM_FILE, OpenMetadataType.PROPERTIES_FILE.typeName, null, OpenMetadataType.PROPERTIES_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    YAML_FILE("YAML File", PROPERTIES_FILE, OpenMetadataType.YAML_FILE.typeName, null, OpenMetadataType.YAML_FILE.description, "https://egeria-project.org/types/2/0280-Software-Development-Assets/"),
    LOG_FILE("Log File", DATA_FILE, OpenMetadataType.LOG_FILE.typeName, null, OpenMetadataType.LOG_FILE.description, "https://egeria-project.org/types/2/0223-Events-and-Logs/"),
    ARCHIVE_FILE("Archive File", DATA_FILE, OpenMetadataType.ARCHIVE_FILE.typeName, null, OpenMetadataType.ARCHIVE_FILE.description, "https://egeria-project.org/types/2/0226-Archive-Files/"),
    KEYSTORE_FILE("Keystore File", DATA_FILE, OpenMetadataType.KEYSTORE_FILE.typeName, null, OpenMetadataType.KEYSTORE_FILE.description, "https://egeria-project.org/types/2/0226-Archive-Files/"),
    FILE_FOLDER("FileFolder", DATA_ASSET, OpenMetadataType.FILE_FOLDER.typeName, null, "A directory (folder) that holds files that are potential data sources.", "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    DATA_FOLDER("Data Folder", FILE_FOLDER, OpenMetadataType.DATA_FOLDER.typeName, null, "A directory (folder) that holds files representing a single data source.", "https://egeria-project.org/types/2/0220-Files-and-Folders/"),
    JDBC_RELATIONAL_DATABASE("JDBC Relational Database", DATA_ASSET, "RelationalDatabase", null, "A database hosted on a relational database server capable of being called through a JDBC Driver.", "https://en.wikipedia.org/wiki/Java_Database_Connectivity"),
    JDBC_RELATIONAL_DATABASE_SCHEMA("JDBC Relational Database Schema", DATA_ASSET, "DeployedDatabaseSchema", null, "A database schema hosted on a relational database server capable of being called through a JDBC Driver.", "https://en.wikipedia.org/wiki/Java_Database_Connectivity"),
    JDBC_RELATIONAL_DATABASE_TABLE("JDBC Relational Database Table", DATA_ASSET, OpenMetadataType.TABLE_DATA_SET.typeName, null, "A database table hosted on a relational database server capable of being called through a JDBC Driver.", "https://en.wikipedia.org/wiki/Java_Database_Connectivity"),
    POSTGRESQL_DATABASE("PostgreSQL Relational Database", JDBC_RELATIONAL_DATABASE, "RelationalDatabase", null, "A database hosted on a PostgreSQL server.", "https://www.postgresql.org/"),
    POSTGRESQL_DATABASE_SCHEMA("PostgreSQL Relational Database Schema", DATA_ASSET, "DeployedDatabaseSchema", null, "A database schema hosted on a PostgreSQL relational database server capable of being called through a JDBC Driver.", "https://www.postgresql.org/"),
    POSTGRESQL_DATABASE_TABLE("PostgreSQL Relational Database Table", DATA_ASSET, OpenMetadataType.TABLE_DATA_SET.typeName, null, "A database table hosted on a PostgreSQL relational database server capable of being called through a JDBC Driver.", "https://www.postgresql.org/"),
    BARE_METAL_COMPUTER("Bare Metal Computer", null, OpenMetadataType.BARE_METAL_COMPUTER.typeName, null, "A computer (hardware) with operating system for running software.", "https://egeria-project.org/types/0/0035-Complex-Hosts/"),
    LAPTOP_COMPUTER("Laptop Computer", BARE_METAL_COMPUTER, OpenMetadataType.BARE_METAL_COMPUTER.typeName, null, "A portable computer with screen, keyboard and battery power.", "https://egeria-project.org/types/0/0035-Complex-Hosts/"),
    MACBOOK_PRO("Apple MacBook Pro", LAPTOP_COMPUTER, OpenMetadataType.BARE_METAL_COMPUTER.typeName, null, "A professional laptop supplied by Apple that runs the macOS operating system.", "https://egeria-project.org/types/0/0035-Complex-Hosts/"),
    SMALL_FORM_FACTOR_COMPUTER("Small Form Factor (SFF) Computer", BARE_METAL_COMPUTER, OpenMetadataType.BARE_METAL_COMPUTER.typeName, null, "A small hardware server enclosed in a protective case that can sit under a desk.", "https://egeria-project.org/types/0/0035-Complex-Hosts/"),
    SOFTWARE_SERVER("Software Server", null, OpenMetadataType.SOFTWARE_SERVER.typeName, null, "A callable software server.", "https://egeria-project.org/types/0/0040-Software-Servers/"),
    SOFTWARE_CAPABILITY("Software Capability", null, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, null, "A callable software capability supporting specific types of assets.", "https://egeria-project.org/types/0/0042-Software-Capabilities/"),
    POSTGRESQL_SERVER("PostgreSQL Server", SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, null, "A database server running the PostgreSQL software.", "https://www.postgresql.org/"),
    APACHE_ATLAS_SERVER("Apache Atlas Server", SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, null, "A data catalog for the Hadoop ecosystem.", "https://atlas.apache.org/"),
    APACHE_KAFKA_SERVER("Apache Kafka Server", SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, null, "A software server supporting an event broker that enables high speed, reliable topic-based event exchange.", "https://kafka.apache.org/"),
    APACHE_KAFKA_EVENT_BROKER("Apache Kafka Event Broker", SOFTWARE_CAPABILITY, OpenMetadataType.EVENT_BROKER.typeName, null, "A software capability that enables high speed, reliable topic-based event exchange.", "https://kafka.apache.org/"),
    APACHE_KAFKA_TOPIC("Apache Kafka Topic", DATA_ASSET, OpenMetadataType.KAFKA_TOPIC.typeName, null, "An event topic supporting high speed, reliable event exchange.", "https://kafka.apache.org/"),
    FILE_SYSTEM("File System", SOFTWARE_CAPABILITY, OpenMetadataType.DATA_MANAGER.typeName, "FileSystem", "A system that manages hierarchically organized files on persistent storage.", "https://egeria-project.org/types/0/0056-Resource-Managers/"),
    UNIX_FILE_SYSTEM("UNIX File System", SOFTWARE_CAPABILITY, OpenMetadataType.DATA_MANAGER.typeName, "FileSystem", "A Unix capability that manages hierarchically organized files on persistent storage.", "https://egeria-project.org/types/0/0056-Resource-Managers/"),
    ASSET_CATALOG("Asset Metadata Catalog", SOFTWARE_CAPABILITY, OpenMetadataType.CATALOG.typeName, "AssetManager", "A catalog of metadata that describes assets such as deployed systems, data sources and processes.", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    API_MANAGER("API Manager", SOFTWARE_CAPABILITY, OpenMetadataType.API_MANAGER.typeName, null, "A software capability that provides callable APIs.", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    REST_API_MANAGER("REST API Manager", API_MANAGER, OpenMetadataType.API_MANAGER.typeName, null, "A software capability that provides callable APIs supporting the REST protocol.", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    EVENT_BROKER("Event Broker", SOFTWARE_CAPABILITY, OpenMetadataType.EVENT_BROKER.typeName, null, "A system that manages the asynchronous exchange of messages (events) from once to potentially many recipients.  Typically, this exchange of events is organized into groups called topics.", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    RELATIONAL_DATABASE_MANAGER("Relational database manager (RDBMS)", SOFTWARE_CAPABILITY, OpenMetadataType.DATABASE_MANAGER.typeName, null, "A capability that manages collections of data called relational databases which in turn are organized into a tabular format and accessed via the Structured Query Language (SQL).", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    POSTGRESQL_DATABASE_MANAGER("PostgreSQL database manager (RDBMS)", RELATIONAL_DATABASE_MANAGER, OpenMetadataType.DATABASE_MANAGER.typeName, null, "The PostgreSQL capability that manages collections of data called relational databases which in turn are organized into a tabular format and accessed via the Structured Query Language (SQL).", "https://egeria-project.org/types/0/0050-Applications-and-Processes/"),
    OMAG_SERVER_PLATFORM("OMAG Server Platform", SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, null, "An Open Metadata and Governance (OMAG) runtime for running one to many OMAG Servers.", "https://egeria-project.org/concepts/omag-server-platform/"),
    OMAG_SERVER_RUNTIME("OMAG Server Runtime", SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, null, "An Open Metadata and Governance (OMAG) runtime for running a single OMAG Server.", "https://egeria-project.org/concepts/omag-server-runtime/"),
    SOFTWARE_COMPONENT("Software Component", null, "DeployedSoftwareComponent", null, "A deployable software component.", "https://egeria-project.org/types/2/0215-Software-Components/"),
    OCF_CONNECTOR("Open Connector Framework (OCF) Connector", null, "DeployedSoftwareComponent", null, "A pluggable software component that conforms to the Open Connector Framework (OCF).", "https://egeria-project.org/concepts/connector/"),
    REPOSITORY_CONNECTOR("OMRS Repository Connector", null, "DeployedSoftwareComponent", null, "Maps open metadata repository calls defined by the Open Metadata Repository Services (OMRS) to a metadata repository API and event notifications.", "https://egeria-project.org/concepts/repository-connector/"),
    GOVERNANCE_ENGINE("Governance Engine", null, OpenMetadataType.GOVERNANCE_ENGINE.typeName, null, "Manages the execution of automated governance activity requested via engine actions.", "https://egeria-project.org/concepts/governance-engine/"),
    GOVERNANCE_SERVICE("Governance Service", OCF_CONNECTOR, OpenMetadataType.GOVERNANCE_SERVICE.typeName, null, "Provides the description of a component that implements an automated governance activity.", "https://egeria-project.org/concepts/governance-service/"),
    OPEN_DISCOVERY_SERVICE_CONNECTOR("Open Discovery Service", GOVERNANCE_SERVICE, OpenMetadataType.OPEN_DISCOVERY_SERVICE.typeName, null, "A connector that analyzing the contents of a digital resource and produces a discovery analysis report.", "https://egeria-project.org/concepts/open-discovery-service/"),
    OPEN_DISCOVERY_ENGINE("Open Discovery Engine", GOVERNANCE_ENGINE, OpenMetadataType.OPEN_DISCOVERY_ENGINE.typeName, null, "A governance engine that runs open discovery services.", "https://egeria-project.org/concepts/open-discovery-engine/"),
    GOVERNANCE_ACTION_SERVICE_CONNECTOR("Governance Action Service", GOVERNANCE_SERVICE, OpenMetadataType.GOVERNANCE_ACTION_SERVICE.typeName, null, "A connector that coordinates governance of digital resources and metadata.", "https://egeria-project.org/concepts/governance-action-service/"),
    GOVERNANCE_ACTION_ENGINE("Governance Action Engine", GOVERNANCE_ENGINE, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, null, "A governance engine that runs governance action services.", "https://egeria-project.org/concepts/governance-action-engine/"),
    CONTEXT_EVENT_SERVICE_CONNECTOR("Context Event Service", GOVERNANCE_SERVICE, OpenMetadataType.CONTEXT_EVENT_SERVICE.typeName, null, "A connector that coordinates governance of context events.", "https://egeria-project.org/concepts/context-event-service/"),
    CONTEXT_EVENT_ENGINE("Context Event Engine", GOVERNANCE_ENGINE, OpenMetadataType.CONTEXT_EVENT_ENGINE.typeName, null, "A governance engine that runs context event services.", "https://egeria-project.org/concepts/context-event-engine/"),
    SURVEY_ACTION_SERVICE_CONNECTOR("Survey Action Service", GOVERNANCE_SERVICE, OpenMetadataType.SURVEY_ACTION_SERVICE.typeName, null, "A connector that coordinates asset surveys.", "https://egeria-project.org/concepts/survey-action-service/"),
    SURVEY_ACTION_ENGINE("Survey Action Engine", GOVERNANCE_ENGINE, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, null, "A governance engine that runs survey action services.", "https://egeria-project.org/concepts/survey-action-engine/"),
    REPOSITORY_GOVERNANCE_SERVICE_CONNECTOR("Repository Governance Service Connector", GOVERNANCE_SERVICE, OpenMetadataType.REPOSITORY_GOVERNANCE_SERVICE.typeName, null, "A connector that dynamically governs the activity of the open metadata repositories.", "https://egeria-project.org/concepts/repository-governance-service"),
    REPOSITORY_GOVERNANCE_ENGINE("Repository Governance Engine", GOVERNANCE_ENGINE, OpenMetadataType.REPOSITORY_GOVERNANCE_ENGINE.typeName, null, "A governance engine that runs repository governance services.", "https://egeria-project.org/concepts/repository-governance-engine/"),
    INTEGRATION_CONNECTOR("Integration Connector", OCF_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party technology.", "https://egeria-project.org/services/omvs/analytics-integrator/overview"),
    ANALYTICS_INTEGRATION_CONNECTOR("Analytics Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party analytics technology.", "https://egeria-project.org/services/omvs/analytics-integrator/overview"),
    API_INTEGRATION_CONNECTOR("API Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party API management technology.", "https://egeria-project.org/services/omvs/api-integrator/overview"),
    CATALOG_INTEGRATION_CONNECTOR("Catalog Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party metadata catalog technology.", "https://egeria-project.org/services/omvs/catalog-integrator/overview"),
    DATABASE_INTEGRATION_CONNECTOR("Database Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party database technology.", "https://egeria-project.org/services/omvs/database-integrator/overview"),
    DISPLAY_INTEGRATION_CONNECTOR("Display Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party display (user interaction) technology.", "https://egeria-project.org/services/omvs/display-integrator/overview"),
    FILES_INTEGRATION_CONNECTOR("Files Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party filesystem technology.", "https://egeria-project.org/services/omvs/files-integrator/overview"),
    INFRASTRUCTURE_INTEGRATION_CONNECTOR("Infrastructure Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party infrastructure catalog (CMDB) technology.", "https://egeria-project.org/services/omvs/infrastructure-integrator/overview"),
    LINEAGE_INTEGRATION_CONNECTOR("Lineage Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party lineage capture technology.", "https://egeria-project.org/services/omvs/lineage-integrator/overview"),
    ORGANIZATION_INTEGRATION_CONNECTOR("Organization Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party application containing data about people and organizations.", "https://egeria-project.org/services/omvs/organization-integrator/overview"),
    SEARCH_INTEGRATION_CONNECTOR("Search Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party search technology.", "https://egeria-project.org/services/omvs/search-integrator/overview"),
    SECURITY_INTEGRATION_CONNECTOR("Security Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party security management technology.", "https://egeria-project.org/services/omvs/security-integrator/overview"),
    TOPIC_INTEGRATION_CONNECTOR("Topic Integration Connector", INTEGRATION_CONNECTOR, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, "Connector that manages metadata exchange with a third party event management technology.", "https://egeria-project.org/services/omvs/topic-integrator/overview"),
    PLATFORM_SECURITY_CONNECTOR("Platform Metadata Security Connector", OCF_CONNECTOR, "DeployedConnector", null, "Connector that manages authorization requests to the OMAG Server Platform.", "https://egeria-project.org/concepts/platform-metadata-security-connector/"),
    SERVER_SECURITY_CONNECTOR("Server Metadata Security Connector", OCF_CONNECTOR, "DeployedConnector", null, "Connector that manages authorization requests to the OMAG Server.", "https://egeria-project.org/concepts/server-metadata-security-connector/"),
    ARCHIVE_STORE_CONNECTOR("Open Metadata Archive Store Connector", OCF_CONNECTOR, "DeployedConnector", null, "Reads and writes open metadata types and instances to an open metadata archive.", "https://egeria-project.org/concepts/open-metadata-archive-store-connector/"),
    COHORT_REGISTRY_STORE("Cohort Registry Store", OCF_CONNECTOR, "DeployedConnector", null, "Stores information about the repositories registered in the open metadata repository cohort.", "https://egeria-project.org/concepts/cohort-registry-store-connector/"),
    AUDIT_LOG_DESTINATION("Audit Log Destination", OCF_CONNECTOR, "DeployedConnector", null, "Reads and writes records to the Open Metadata Repository Services (OMRS) audit log.", "https://egeria-project.org/concepts/audit-log/"),
    INTEGRATION_GROUP("Dynamic Integration Group", null, OpenMetadataType.INTEGRATION_GROUP.typeName, null, "Provides the list of integration connectors that should run in an Integration Daemon.  The Integration Daemon is configured with the qualified names of the integration group(s) that provide its connector list.", "https://egeria-project.org/concepts/integration-group/");

    private final String deployedImplementationType;
    private final DeployedImplementationType isATypeOf;
    private final String associatedTypeName;
    private final String associatedClassification;
    private final String description;
    private final String wikiLink;

    public static DeployedImplementationType getDefinitionFromDeployedImplementationType(String deployedImplementationType) {
        if (deployedImplementationType != null) {
            for (DeployedImplementationType definition : DeployedImplementationType.values()) {
                if (!definition.getDeployedImplementationType().equals(deployedImplementationType)) continue;
                return definition;
            }
        }
        return null;
    }

    private DeployedImplementationType(String deployedImplementationType, DeployedImplementationType isATypeOf, String associatedTypeName, String associatedClassification, String description, String wikiLink) {
        this.deployedImplementationType = deployedImplementationType;
        this.isATypeOf = isATypeOf;
        this.associatedTypeName = associatedTypeName;
        this.associatedClassification = associatedClassification;
        this.description = description;
        this.wikiLink = wikiLink;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationType getIsATypeOf() {
        return this.isATypeOf;
    }

    public String getAssociatedTypeName() {
        return this.associatedTypeName;
    }

    public String getAssociatedClassification() {
        return this.associatedClassification;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(this.associatedTypeName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, this.deployedImplementationType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(this.associatedTypeName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String toString() {
        return "DeployedImplementationType{" + this.deployedImplementationType + "}";
    }
}

