/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ProjectPhase {
    DEFINE("Define", "The project's scope, mission and stakeholders are being defined."),
    PLAN("Plan", "The project activity and resources are being defined in a work plan."),
    RUN("Run", "The project's scope, mission and stakeholders are being defined."),
    HANDOVER("Handover", "Project deliverables are being finalized and handed off to an operational team."),
    DONE("Done", "The project has completed its deliverables.");

    private final String name;
    private final String description;

    private ProjectPhase(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.PROJECT_PHASE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.PROJECT_PHASE.name, null);
    }

    public String toString() {
        return "ProjectPhase{" + this.name + "}";
    }
}

