/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyOpenMetadataStore;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFAuditCode;
import org.odpi.openmetadata.frameworks.surveyaction.ffdc.SAFErrorCode;

public class SurveyContext {
    private final String userId;
    private final String assetGUID;
    private final Map<String, String> requestParameters;
    private final SurveyAssetStore assetStore;
    private final AnnotationStore annotationStore;
    private final SurveyOpenMetadataStore openMetadataStore;
    private final String surveyActionServiceName;
    private final String requesterUserId;
    private final AuditLog auditLog;
    private final FileClassifier fileClassifier;
    private boolean isActive = true;

    public SurveyContext(String userId, String assetGUID, Map<String, String> requestParameters, SurveyAssetStore assetStore, AnnotationStore annotationStore, SurveyOpenMetadataStore openMetadataStore, String surveyActionServiceName, String requesterUserId, AuditLog auditLog) {
        this.userId = userId;
        this.assetGUID = assetGUID;
        this.requestParameters = requestParameters;
        this.assetStore = assetStore;
        this.annotationStore = annotationStore;
        this.openMetadataStore = openMetadataStore;
        this.surveyActionServiceName = surveyActionServiceName;
        this.requesterUserId = requesterUserId;
        this.auditLog = auditLog;
        this.fileClassifier = new FileClassifier(openMetadataStore);
    }

    public String getAssetGUID() throws ConnectorCheckedException {
        String methodName = "getAssetGUID";
        this.validateIsActive("getAssetGUID");
        return this.assetGUID;
    }

    public Map<String, String> getRequestParameters() throws ConnectorCheckedException {
        String methodName = "getRequestParameters";
        this.validateIsActive("getRequestParameters");
        return this.requestParameters;
    }

    public String getRequesterUserId() {
        return this.requesterUserId;
    }

    public SurveyAssetStore getAssetStore() throws ConnectorCheckedException {
        String methodName = "getAssetStore";
        this.validateIsActive("getAssetStore");
        return this.assetStore;
    }

    public AnnotationStore getAnnotationStore() throws ConnectorCheckedException {
        String methodName = "getAnnotationStore";
        this.validateIsActive("getAnnotationStore");
        return this.annotationStore;
    }

    public SurveyOpenMetadataStore getOpenMetadataStore() throws ConnectorCheckedException {
        String methodName = "getOpenMetadataStore";
        this.validateIsActive("getOpenMetadataStore");
        return this.openMetadataStore;
    }

    public FileClassifier getFileClassifier() throws ConnectorCheckedException {
        String methodName = "getFileClassifier";
        this.validateIsActive("getFileClassifier");
        return this.fileClassifier;
    }

    public void disconnect() throws ConnectorCheckedException {
        this.isActive = false;
    }

    private void validateIsActive(String methodName) throws ConnectorCheckedException {
        if (!this.isActive) {
            if (this.auditLog != null) {
                this.auditLog.logMessage(methodName, SAFAuditCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName));
            }
            throw new ConnectorCheckedException(SAFErrorCode.DISCONNECT_DETECTED.getMessageDefinition(this.surveyActionServiceName), this.getClass().getName(), methodName);
        }
    }

    public String toString() {
        return "SurveyContext{userId='" + this.userId + "', assetGUID='" + this.assetGUID + "', requestParameters=" + this.requestParameters + ", assetStore=" + this.assetStore + ", annotationStore=" + this.annotationStore + ", openMetadataStore=" + this.openMetadataStore + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        SurveyContext that = (SurveyContext)objectToCompare;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.assetGUID, that.assetGUID) && Objects.equals(this.requestParameters, that.requestParameters) && Objects.equals(this.assetStore, that.assetStore) && Objects.equals(this.annotationStore, that.annotationStore) && Objects.equals(this.openMetadataStore, that.openMetadataStore);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.assetGUID, this.requestParameters, this.assetStore, this.annotationStore, this.openMetadataStore);
    }
}

