/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalTableMetric implements SurveyMetric
{
    TABLE_SIZE("tableSize", "long", "Table size", "Number of stored bytes in the table."),
    TABLE_NAME("tableName", "string", "Table name", "Name of table."),
    TABLE_QNAME("tableQualifiedName", "string", "Table qualified name", "Qualified name of table showing the database name and schema name."),
    TABLE_TYPE("tableDataType", "string", "Table type", "Is this a standard table, view or materialized view?"),
    COLUMN_COUNT("columnCount", "long", "Number of columns", "Count of columns in the database table/view.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalTableMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(RelationalDatabaseMetric.values()));
    }

    public String toString() {
        return "RelationalTableMetric{" + this.displayName + "}";
    }
}

