/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourcePhysicalStatusAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ResourcePhysicalStatusAnnotation.class, name="DataSourcePhysicalStatusAnnotation")})
public class ResourceMeasureAnnotation
extends Annotation {
    private Map<String, String> resourceProperties = null;

    public ResourceMeasureAnnotation() {
    }

    public ResourceMeasureAnnotation(ResourceMeasureAnnotation template) {
        super(template);
        if (template != null) {
            this.resourceProperties = template.getResourceProperties();
        }
    }

    public Map<String, String> getResourceProperties() {
        if (this.resourceProperties == null) {
            return null;
        }
        if (this.resourceProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.resourceProperties);
    }

    public void setResourceProperties(Map<String, String> resourceProperties) {
        this.resourceProperties = resourceProperties;
    }

    @Override
    public String toString() {
        return "ResourceMeasurementAnnotation{resourceProperties=" + this.resourceProperties + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ResourceMeasureAnnotation that = (ResourceMeasureAnnotation)objectToCompare;
        return Objects.equals(this.getResourceProperties(), that.getResourceProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResourceProperties());
    }
}

