/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.gaf.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OMAGGAFAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TypeDefListResponse
extends OMAGGAFAPIResponse {
    private List<OpenMetadataTypeDef> typeDefs = null;

    public TypeDefListResponse() {
    }

    public TypeDefListResponse(TypeDefListResponse template) {
        super(template);
        if (template != null) {
            this.typeDefs = template.getTypeDefs();
        }
    }

    public List<OpenMetadataTypeDef> getTypeDefs() {
        if (this.typeDefs == null) {
            return null;
        }
        if (this.typeDefs.isEmpty()) {
            return null;
        }
        ArrayList<OpenMetadataTypeDef> clonedTypeDefs = new ArrayList<OpenMetadataTypeDef>();
        for (OpenMetadataTypeDef typeDef : this.typeDefs) {
            clonedTypeDefs.add(typeDef.cloneFromSubclass());
        }
        return clonedTypeDefs;
    }

    public void setTypeDefs(List<OpenMetadataTypeDef> typeDefs) {
        this.typeDefs = typeDefs;
    }

    @Override
    public String toString() {
        return "TypeDefListResponse{typeDefs=" + this.typeDefs + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TypeDefListResponse)) {
            return false;
        }
        TypeDefListResponse that = (TypeDefListResponse)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.getTypeDefs(), that.getTypeDefs());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTypeDefs());
    }
}

