/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgeriaConnectedAssetProperties
extends ConnectedAssetProperties {
    private String serviceName;
    private String remoteServerName;
    private String userId = null;
    private String localServerUserId = null;
    private String localServerPassword = null;
    private String platformURLRoot = null;
    private String connectorInstanceId = null;
    private ConnectionProperties connection = null;
    private String assetGUID = null;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(EgeriaConnectedAssetProperties.class);

    public EgeriaConnectedAssetProperties(String serviceName, String remoteServerName, String userId, String platformURLRoot, String connectorInstanceId, ConnectionProperties connection, String assetGUID) {
        this.serviceName = serviceName;
        this.remoteServerName = remoteServerName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.connectorInstanceId = connectorInstanceId;
        this.connection = connection;
        this.assetGUID = assetGUID;
    }

    public EgeriaConnectedAssetProperties(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String userId, String platformURLRoot, String connectorInstanceId, ConnectionProperties connection, String assetGUID) {
        this.serviceName = serviceName;
        this.remoteServerName = remoteServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.connectorInstanceId = connectorInstanceId;
        this.connection = connection;
        this.assetGUID = assetGUID;
    }

    public EgeriaConnectedAssetProperties(EgeriaConnectedAssetProperties template) {
        super(template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.remoteServerName = template.remoteServerName;
            this.localServerUserId = template.localServerUserId;
            this.localServerPassword = template.localServerPassword;
            this.userId = template.userId;
            this.connection = template.connection;
            this.connectorInstanceId = template.connectorInstanceId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
        }
    }

    @Override
    public void refresh() throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "refresh";
        log.debug("Calling method: refresh");
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            this.assetProperties = this.localServerUserId != null && this.localServerPassword != null ? ConnectedAssetUniverse.create(this.serviceName, this.remoteServerName, this.localServerUserId, this.localServerPassword, this.platformURLRoot, this.userId, this.assetGUID, this.connection.getGUID()) : ConnectedAssetUniverse.create(this.serviceName, this.remoteServerName, this.platformURLRoot, this.userId, this.assetGUID, this.connection.getGUID());
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "refresh", this.remoteServerName, this.platformURLRoot);
        }
        log.debug("Returning from method: refresh having retrieved: " + this.assetProperties.toString());
    }

    @Override
    public String toString() {
        return "EgeriaConnectedAssetProperties{serviceName='" + this.serviceName + "', remoteServerName='" + this.remoteServerName + "', userId='" + this.userId + "', localServerUserId='" + this.localServerUserId + "', platformURLRoot='" + this.platformURLRoot + "', connectorInstanceId='" + this.connectorInstanceId + "', connection=" + this.connection + ", assetGUID='" + this.assetGUID + "', extendedProperties=" + this.assetProperties + "}";
    }
}

