/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;

public enum OCFMetadataAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("CONNECTED-ASSET-SERVICES-0001", AuditLogRecordSeverityLevel.STARTUP, "The Open Connector Framework (OCF) Metadata Management Service is initializing the connected asset services in a new server instance", "The local server has started up a new instance of the service which provides the metadata lookup services for OCF Connectors.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("CONNECTED-ASSET-SERVICES-0003", AuditLogRecordSeverityLevel.STARTUP, "The Open Connector Framework (OCF) Metadata Management Service has initialized a new instance for server {0}", "The service has completed initialization of a new server instance.", "Verify that the service has started correctly."),
    SERVICE_SHUTDOWN("CONNECTED-ASSET-SERVICES-0004", AuditLogRecordSeverityLevel.SHUTDOWN, "The Open Connector Framework (OCF) Metadata Management Service is shutting down its instance of the connected asset services for server {0}", "The local administrator has requested shut down of a server instance.", "No action is required if the server is shutting down."),
    SERVICE_INSTANCE_FAILURE("CONNECTED-ASSET-SERVICES-0005", AuditLogRecordSeverityLevel.ERROR, "The Open Connector Framework (OCF) Metadata Management Service is unable to initialize a new instance of the connected asset services; error message is {0}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ASSET_AUDIT_LOG("CONNECTED-ASSET-SERVICES-0006", AuditLogRecordSeverityLevel.INFO, "Log message for asset {0} from governance service {1}: {2}", "A governance service has logged a message about an asset.", "Review the message to ensure no action is required.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OCFMetadataAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    @Override
    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    @Override
    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

