/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MoreInformationResponse
extends PagedResponse {
    private List<Referenceable> list = null;
    private int startingFromElement = 0;

    public MoreInformationResponse() {
    }

    public MoreInformationResponse(MoreInformationResponse template) {
        super(template);
        if (template != null) {
            this.list = template.getList();
        }
    }

    public List<Referenceable> getList() {
        if (this.list == null) {
            return null;
        }
        if (this.list.isEmpty()) {
            return null;
        }
        ArrayList<Referenceable> clonedList = new ArrayList<Referenceable>();
        for (Referenceable existingElement : this.list) {
            clonedList.add(new Referenceable(existingElement));
        }
        return clonedList;
    }

    public void setList(List<Referenceable> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return "MoreInformationResponse{list=" + this.list + ", startingFromElement=" + this.startingFromElement + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MoreInformationResponse that = (MoreInformationResponse)objectToCompare;
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getList(), that.getList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getList(), this.getStartingFromElement());
    }
}

