/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceablesResponse
extends PagedResponse {
    private List<Referenceable> referenceables = null;

    public ReferenceablesResponse() {
    }

    public ReferenceablesResponse(ReferenceablesResponse template) {
        super(template);
        if (template != null) {
            this.referenceables = template.getReferenceables();
        }
    }

    public List<Referenceable> getReferenceables() {
        if (this.referenceables == null) {
            return null;
        }
        if (this.referenceables.isEmpty()) {
            return null;
        }
        ArrayList<Referenceable> clonedList = new ArrayList<Referenceable>();
        for (Referenceable existingElement : this.referenceables) {
            clonedList.add(new Referenceable(existingElement));
        }
        return clonedList;
    }

    public void setReferenceables(List<Referenceable> referenceables) {
        this.referenceables = referenceables;
    }

    @Override
    public String toString() {
        return "ReferenceablesResponse{referenceables=" + this.referenceables + ", startingFromElement=" + this.getStartingFromElement() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceablesResponse that = (ReferenceablesResponse)objectToCompare;
        return Objects.equals(this.getReferenceables(), that.getReferenceables());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getReferenceables());
    }
}

