/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class EgeriaReport {
    private final FileOutputStream fileOutStream;
    private final boolean printToConsole;

    public String getSpaceIndent(int indentLevel) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append("   ");
        }
        return indent.toString();
    }

    public String getHeadingLevel(int indentLevel) {
        if (indentLevel > 5) {
            StringBuilder indent = new StringBuilder("###### ");
            for (int i = 5; i < indentLevel; ++i) {
                indent.append("==");
            }
            return indent.append("> ").toString();
        }
        StringBuilder indent = new StringBuilder("#");
        for (int i = 0; i < indentLevel; ++i) {
            indent.append("#");
        }
        return indent.append(" ").toString();
    }

    public void printReportTitle(int indentLevel, String reportTitle) throws IOException {
        if (this.printToConsole) {
            System.out.println(this.getSpaceIndent(indentLevel) + reportTitle);
        }
        String reportString = this.getHeadingLevel(indentLevel) + reportTitle + "\n\n";
        this.fileOutStream.write(reportString.getBytes());
    }

    public void printReportSubheading(int indentLevel, String titleText) throws IOException {
        if (this.printToConsole) {
            System.out.println(this.getSpaceIndent(indentLevel) + titleText);
        }
        String reportString = this.getHeadingLevel(indentLevel) + titleText + "\n";
        this.fileOutStream.write(reportString.getBytes());
    }

    public void printReportLine(int indentLevel, String elementLabel, String elementText) throws IOException {
        if (elementText == null) {
            if (this.printToConsole) {
                System.out.println(this.getSpaceIndent(indentLevel) + elementLabel + ": <null>");
            }
            String reportString = "* **" + elementLabel + "**: *null*\n";
            this.fileOutStream.write(reportString.getBytes());
        } else {
            if (this.printToConsole) {
                System.out.println(this.getSpaceIndent(indentLevel) + elementLabel + ": " + elementText);
            }
            String reportString = "* **" + elementLabel + "**: " + elementText + "\n";
            this.fileOutStream.write(reportString.getBytes());
        }
    }

    public void printReportLine(int indentLevel, String reportText) throws IOException {
        if (this.printToConsole) {
            System.out.println(this.getSpaceIndent(indentLevel) + reportText);
        }
        this.fileOutStream.write(reportText.getBytes());
        this.fileOutStream.write("\n".getBytes());
    }

    public void printElementInTable(int indentLevel, boolean firstElement, String guid, String qualifiedName, String displayName, String description) throws IOException {
        if (firstElement) {
            this.printReportLine(indentLevel, "");
            this.printReportLine(indentLevel, "|----------------------------------+-----------------------------+--------------------+------------------------------|");
            this.printReportLine(indentLevel, "| Unique identifier (GUID)         | Unique name (qualifiedName) | Display name       | Description                  |");
            this.printReportLine(indentLevel, "|----------------------------------+-----------------------------+--------------------+------------------------------|");
        }
        this.printReportLine(indentLevel, "| " + guid);
        this.printReportLine(indentLevel, " | " + qualifiedName);
        this.printReportLine(indentLevel, " | " + displayName);
        this.printReportLine(indentLevel, " | " + description);
        this.printReportLine(indentLevel, " |");
    }

    public void printElementInTable(int indentLevel, List<String> tableHeadings, List<String> tableRow) throws IOException {
        if (tableHeadings != null) {
            String separatorChar = "|";
            StringBuilder dottedLine = new StringBuilder();
            StringBuilder headingLine = new StringBuilder("\n| ");
            for (int i = 0; i < tableHeadings.size(); ++i) {
                dottedLine.append(separatorChar);
                separatorChar = " | ";
                dottedLine.append("--------------");
                headingLine.append(tableHeadings.get(i));
                headingLine.append(" |");
            }
            dottedLine.append("|");
            this.printReportLine(indentLevel, headingLine.toString());
            this.printReportLine(indentLevel, dottedLine.toString());
        }
        StringBuilder tableRowLine = new StringBuilder("|");
        for (int i = 0; i < tableRow.size(); ++i) {
            tableRowLine.append(tableRow.get(i));
            tableRowLine.append("|");
        }
        this.printReportLine(indentLevel, tableRowLine.toString());
    }

    public void printConnection(int detailIndentLevel, String elementLabel, Connection connection) throws IOException {
        if (connection == null) {
            this.printReportLine(detailIndentLevel, elementLabel, null);
        } else {
            this.printReportSubheading(detailIndentLevel, elementLabel);
            if (connection.getConnectorType() == null) {
                this.printReportLine(detailIndentLevel + 1, "Implementation", null);
            } else {
                this.printReportLine(detailIndentLevel + 1, "Implementation", connection.getConnectorType().getConnectorProviderClassName());
            }
            if (connection.getEndpoint() == null) {
                this.printReportLine(detailIndentLevel + 1, "Location", null);
            } else {
                this.printReportLine(detailIndentLevel + 1, "Location", connection.getEndpoint().getAddress());
            }
            if (connection.getConfigurationProperties() != null) {
                this.printReportLine(detailIndentLevel + 1, "Configuration Properties", connection.getConfigurationProperties().toString());
            }
        }
    }

    public void printRegisteredServices(int indentLevel, List<RegisteredOMAGService> registeredOMAGServices) throws IOException {
        if (registeredOMAGServices != null) {
            for (RegisteredOMAGService serviceDescription : registeredOMAGServices) {
                this.printReportLine(indentLevel, serviceDescription.getServiceName(), serviceDescription.getServiceDescription());
            }
        }
    }

    public EgeriaReport(String reportFileName) throws IOException {
        this(reportFileName, true);
    }

    public EgeriaReport(String reportFileName, boolean printToConsole) throws IOException {
        String licenseString = "<!-- SPDX-License-Identifier: CC-BY-4.0 -->\n";
        String copyrightString = "<!-- Copyright Contributors to the Egeria project. -->\n\n";
        this.printToConsole = printToConsole;
        File reportFile = new File(reportFileName);
        if (reportFile.exists() && !reportFile.delete()) {
            System.out.println("Unable to delete report file: " + reportFileName);
        }
        this.fileOutStream = new FileOutputStream(reportFile);
        this.fileOutStream.write("<!-- SPDX-License-Identifier: CC-BY-4.0 -->\n".getBytes());
        this.fileOutStream.write("<!-- Copyright Contributors to the Egeria project. -->\n\n".getBytes());
    }

    public void closeReport() throws IOException {
        String snippetString = "\n--8<-- \"snippets/abbr.md\"";
        this.fileOutStream.write("\n--8<-- \"snippets/abbr.md\"".getBytes());
    }
}

