/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports.databasereport;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.client.DatabaseManagerClient;
import org.odpi.openmetadata.accessservices.datamanager.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseColumnElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.datamanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseColumnProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseManagerProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.accessservices.datamanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.reports.EgeriaReport;

public class DatabaseReport {
    private final String serverName;
    private final String platformURLRoot;
    private final String clientUserId;
    private MetadataSourceClient metadataSourceClient = null;
    private DatabaseManagerClient databaseManagerClient = null;

    private DatabaseReport(String serverName, String platformURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
        try {
            this.metadataSourceClient = new MetadataSourceClient(serverName, platformURLRoot);
            this.databaseManagerClient = new DatabaseManagerClient(serverName, platformURLRoot);
        }
        catch (Exception error) {
            System.out.println("There was an exception when creating the Data Manager OMAS Client.  Error message is: " + error.getMessage());
        }
    }

    private String getPlatformOrigin() {
        try {
            PlatformServicesClient platformServicesClient = new PlatformServicesClient("MyPlatform", this.platformURLRoot);
            return platformServicesClient.getPlatformOrigin(this.clientUserId);
        }
        catch (Exception error) {
            System.out.println("\n\nThere was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.out.println("Ensure the platform URl is correct and the platform is running");
            return null;
        }
    }

    private String[] getUserInput(String requestText) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(requestText);
            String commandLine = br.readLine();
            return commandLine.split(" ");
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when getting user input.  Error message is: " + error.getMessage());
            return null;
        }
    }

    private void locateDatabase() {
        String endInteractiveMode = "exit";
        String allDatabases = "all";
        String command = null;
        int pageSize = 10;
        int startFrom = -pageSize;
        try {
            do {
                List<DatabaseElement> databases;
                if ((databases = this.databaseManagerClient.findDatabases(this.clientUserId, ".*", startFrom += pageSize, pageSize)) == null) {
                    if (startFrom == 0) {
                        System.out.println("There are no databases in the catalog ... ");
                    } else {
                        System.out.println("There are no more databases to retrieve from the catalog ... ");
                    }
                    break;
                }
                boolean firstDatabase = true;
                for (DatabaseElement databaseElement : databases) {
                    this.displayDatabaseSummary(databaseElement, firstDatabase);
                    firstDatabase = false;
                }
                String requestText = "Enter:\n - the guid of a database to generate a report for a single database\n - 'all' for a report of all listed databases\n - 'exit' to stop \nor just enter to retrieve more databases.\n";
                String[] commandWords = this.getUserInput(requestText);
                if (commandWords == null) continue;
                if (commandWords.length > 0) {
                    command = commandWords[0];
                    command = command.strip();
                }
                if (command == null || "".equals(command) || "exit".equals(command)) continue;
                if ("all".equals(command)) {
                    for (DatabaseElement databaseElement : databases) {
                        this.displayDatabase(databaseElement.getElementHeader().getGUID());
                    }
                } else {
                    this.displayDatabase(command);
                }
            } while (!"exit".equals(command));
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when locating an database.  Error message is: " + error.getMessage());
        }
    }

    private void displayDatabaseSummary(DatabaseElement databaseElement, boolean firstDatabase) {
        if (firstDatabase) {
            System.out.println("| Unique identifier (GUID)         | Unique name (qualifiedName) | Display name       | Description                  |");
            System.out.println("|----------------------------------+-----------------------------+--------------------+------------------------------|");
        }
        if (databaseElement != null) {
            System.out.print("| " + databaseElement.getElementHeader().getGUID());
            System.out.print(" | " + databaseElement.getDatabaseProperties().getQualifiedName());
            System.out.print(" | " + databaseElement.getDatabaseProperties().getName());
            System.out.print(" | " + databaseElement.getDatabaseProperties().getDescription());
            System.out.println(" |");
        }
    }

    private void displayDatabase(String databaseGUID) {
        try {
            DatabaseElement databaseElement = this.databaseManagerClient.getDatabaseByGUID(this.clientUserId, databaseGUID);
            EgeriaReport report = new EgeriaReport("Database " + databaseElement.getDatabaseProperties().getName());
            String reportTitle = "Database report for: ";
            report.printReportTitle(0, "Database report for: " + databaseElement.getDatabaseProperties().getName() + " on server: " + this.serverName);
            report.printElementInTable(0, true, databaseElement.getElementHeader().getGUID(), databaseElement.getDatabaseProperties().getQualifiedName(), databaseElement.getDatabaseProperties().getName(), databaseElement.getDatabaseProperties().getDescription());
            this.displayDatabaseSchemas(report, 1, databaseGUID);
            this.displayTables(report, 1, databaseGUID);
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient.  Error message is: " + error.getMessage());
        }
    }

    private void displayDatabaseSchemas(EgeriaReport report, int indentLevel, String databaseGUID) {
        try {
            List<DatabaseSchemaElement> databaseSchemaElements = this.databaseManagerClient.getSchemasForDatabase(this.clientUserId, databaseGUID, 0, 0);
            if (databaseSchemaElements != null) {
                for (DatabaseSchemaElement databaseSchemaElement : databaseSchemaElements) {
                    report.printElementInTable(indentLevel, true, databaseSchemaElement.getElementHeader().getGUID(), databaseSchemaElement.getDatabaseSchemaProperties().getQualifiedName(), databaseSchemaElement.getDatabaseSchemaProperties().getName(), databaseSchemaElement.getDatabaseSchemaProperties().getDescription());
                    this.displayTables(report, indentLevel + 1, databaseSchemaElement.getElementHeader().getGUID());
                }
            } else {
                report.printReportLine(indentLevel, "No database schemas");
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient for database schemas.  Error message is: " + error.getMessage());
        }
    }

    private void displayTables(EgeriaReport report, int indentLevel, String parentGUID) {
        try {
            List<DatabaseTableElement> databaseTableElements = this.databaseManagerClient.getTablesForDatabaseAsset(this.clientUserId, parentGUID, 0, 0);
            if (databaseTableElements != null) {
                for (DatabaseTableElement databaseTableElement : databaseTableElements) {
                    report.printElementInTable(indentLevel, true, databaseTableElement.getElementHeader().getGUID(), databaseTableElement.getDatabaseTableProperties().getQualifiedName(), databaseTableElement.getDatabaseTableProperties().getDisplayName(), databaseTableElement.getDatabaseTableProperties().getDescription());
                    if (databaseTableElement.getDatabaseColumnCount() <= 0) continue;
                    report.printReportLine(indentLevel, databaseTableElement.getDatabaseColumnCount() + " database tables ...");
                    this.displayColumns(report, indentLevel + 1, databaseTableElement.getElementHeader().getGUID());
                }
            } else {
                report.printReportLine(indentLevel, "No database tables");
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient for database tables.  Error message is: " + error.getMessage());
        }
    }

    private void displayColumns(EgeriaReport report, int indentLevel, String tableGUID) {
        try {
            List<DatabaseColumnElement> databaseColumnElements = this.databaseManagerClient.getColumnsForDatabaseTable(this.clientUserId, tableGUID, 0, 0);
            if (databaseColumnElements != null) {
                for (DatabaseColumnElement databaseColumnElement : databaseColumnElements) {
                    report.printElementInTable(indentLevel, true, databaseColumnElement.getElementHeader().getGUID(), databaseColumnElement.getDatabaseColumnProperties().getQualifiedName(), databaseColumnElement.getDatabaseColumnProperties().getDisplayName(), databaseColumnElement.getDatabaseColumnProperties().getDescription());
                }
            } else {
                report.printReportLine(indentLevel, "No database columns");
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient for database columns.  Error message is: " + error.getMessage());
        }
    }

    private void createSampleDatabases() {
        String databaseManagerName = "SampleDatabases";
        String databaseNamePrefix = "SampleDatabase";
        String databaseNamePrefix2 = "SampleDatabaseSeparateSchemaType";
        String databaseManagerGUID = this.createSampleDatabaseManager("SampleDatabases");
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseA", 0, 0, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseB", 1, 0, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseC", 1, 1, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseD", 1, 1, 1, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseE", 0, 1, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseF", 0, 1, 1, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseG", 2, 25, 30, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeA", 0, 0, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeB", 1, 0, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeC", 1, 1, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeD", 1, 1, 1, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeE", 0, 1, 0, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeF", 0, 1, 1, false);
        this.createSampleDatabase(databaseManagerGUID, "SampleDatabases", "SampleDatabaseSeparateSchemaTypeG", 2, 25, 30, false);
    }

    private String createSampleDatabaseManager(String databaseManagerName) {
        try {
            DatabaseManagerProperties databaseManagerProperties = new DatabaseManagerProperties();
            databaseManagerProperties.setQualifiedName(databaseManagerName);
            return this.metadataSourceClient.createDatabaseManager(this.clientUserId, null, null, databaseManagerProperties);
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient when creating sample databases.  Error message is: " + error.getMessage());
            return null;
        }
    }

    private void createSampleDatabase(String databaseManagerGUID, String databaseManagerName, String databaseName, int numberOfSchemas, int numberOfTables, int numberOfColumns, boolean useSchemaType) {
        Date startTime = new Date();
        try {
            DatabaseProperties databaseProperties = new DatabaseProperties();
            databaseProperties.setQualifiedName(databaseManagerName + ":Database:" + databaseName);
            String databaseGUID = this.databaseManagerClient.createDatabase(this.clientUserId, databaseManagerGUID, databaseManagerName, databaseProperties);
            this.databaseManagerClient.publishDatabase(this.clientUserId, databaseGUID);
            if (numberOfSchemas > 0) {
                for (int s = 0; s < numberOfSchemas; ++s) {
                    String schemaName = "Schema" + s;
                    DatabaseSchemaProperties databaseSchemaProperties = new DatabaseSchemaProperties();
                    databaseSchemaProperties.setQualifiedName(databaseName + "." + schemaName);
                    databaseSchemaProperties.setName(schemaName);
                    databaseSchemaProperties.setDescription("Database schema definition called " + schemaName + " with " + numberOfTables + " tables.");
                    String databaseSchemaGUID = this.databaseManagerClient.createDatabaseSchema(this.clientUserId, databaseManagerGUID, databaseManagerName, databaseGUID, databaseSchemaProperties);
                    if (numberOfTables > 0) {
                        this.createSampleDatabaseTables(databaseManagerGUID, databaseManagerName, databaseSchemaGUID, schemaName, numberOfTables, numberOfColumns, useSchemaType);
                    }
                    this.databaseManagerClient.publishDatabaseSchema(this.clientUserId, databaseSchemaGUID);
                }
            } else {
                this.createSampleDatabaseTables(databaseManagerGUID, databaseManagerName, databaseGUID, databaseName, numberOfTables, numberOfColumns, false);
            }
            Date endTime = new Date();
            System.out.println("Created " + databaseName + " database in " + (endTime.getTime() - startTime.getTime()) + " milliseconds");
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient when creating sample databases.  Error message is: " + error.getMessage());
        }
    }

    private void createSampleDatabaseTables(String databaseManagerGUID, String databaseManagerName, String parentGUID, String parentName, int numberOfTables, int numberOfColumns, boolean useSchemaType) {
        try {
            if (numberOfTables > 0) {
                String databaseSchemaTypeGUID = null;
                if (useSchemaType) {
                    databaseSchemaTypeGUID = this.databaseManagerClient.createDatabaseSchemaType(this.clientUserId, databaseManagerGUID, databaseManagerName, "SchemaOf:" + parentName);
                }
                for (int t = 0; t < numberOfTables; ++t) {
                    String tableName = "Table" + t;
                    DatabaseTableProperties databaseTableProperties = new DatabaseTableProperties();
                    databaseTableProperties.setQualifiedName(parentName + "." + tableName);
                    databaseTableProperties.setDisplayName(tableName);
                    databaseTableProperties.setDescription("Table definition called " + tableName + " with " + numberOfColumns + " columns.");
                    String databaseTableGUID = useSchemaType ? this.databaseManagerClient.createDatabaseTableForSchemaType(this.clientUserId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, databaseTableProperties) : this.databaseManagerClient.createDatabaseTable(this.clientUserId, databaseManagerGUID, databaseManagerName, parentGUID, databaseTableProperties);
                    if (numberOfColumns <= 0) continue;
                    for (int c = 0; c < numberOfColumns; ++c) {
                        String columnName = "Column" + t + "." + c;
                        DatabaseColumnProperties databaseColumnProperties = new DatabaseColumnProperties();
                        databaseColumnProperties.setQualifiedName(parentName + "." + tableName);
                        databaseColumnProperties.setDisplayName(tableName);
                        databaseColumnProperties.setDescription("Column definition called " + columnName + " inside " + tableName + " table.");
                        databaseColumnProperties.setDataType("string");
                        this.databaseManagerClient.createDatabaseColumn(this.clientUserId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseColumnProperties);
                    }
                }
                if (useSchemaType) {
                    this.databaseManagerClient.attachSchemaTypeToDatabaseAsset(this.clientUserId, databaseManagerGUID, databaseManagerName, parentGUID, databaseSchemaTypeGUID);
                }
            }
        }
        catch (Exception error) {
            System.out.println("There was a " + error.getClass().getName() + " exception when calling the Data Manager OMAS DatabaseManagerClient when creating sample databases.  Error message is: " + error.getMessage());
        }
    }

    public static void main(String[] args) {
        String interactiveMode = "interactive";
        String samplesMode = "samples";
        String serverName = "cocoMDS1";
        String platformURLRoot = "https://localhost:9444";
        String clientUserId = "peterprofile";
        String mode = "samples";
        if (args.length > 0) {
            serverName = args[0];
        }
        if (args.length > 1) {
            platformURLRoot = args[1];
        }
        if (args.length > 2) {
            clientUserId = args[2];
        }
        if (args.length > 3) {
            mode = args[3];
        }
        System.out.println("===============================");
        System.out.println("Database Report   " + new Date());
        System.out.println("===============================");
        System.out.print("Running against server: " + serverName + " at " + platformURLRoot);
        DatabaseReport utility = new DatabaseReport(serverName, platformURLRoot, clientUserId);
        HttpHelper.noStrictSSL();
        String platformOrigin = utility.getPlatformOrigin();
        if (platformOrigin != null) {
            System.out.print(" - " + platformOrigin);
        } else {
            System.out.println();
            System.exit(-1);
        }
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        try {
            if ("interactive".equals(mode)) {
                utility.locateDatabase();
            } else if ("samples".equals(mode)) {
                utility.createSampleDatabases();
                utility.locateDatabase();
            } else {
                utility.displayDatabase(mode);
            }
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

