/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EnumDef
extends AttributeTypeDef {
    private static final long serialVersionUID = 1L;
    private List<EnumElementDef> elementDefs = null;
    private EnumElementDef defaultValue = null;

    public EnumDef() {
        super(AttributeTypeDefCategory.ENUM_DEF);
    }

    public EnumDef(EnumDef template) {
        super(template);
        if (template != null) {
            if (template.getElementDefs() != null) {
                this.elementDefs = new ArrayList<EnumElementDef>(template.getElementDefs());
            }
            this.defaultValue = template.getDefaultValue();
        }
    }

    @Override
    public AttributeTypeDef cloneFromSubclass() {
        return new EnumDef(this);
    }

    public List<EnumElementDef> getElementDefs() {
        if (this.elementDefs == null) {
            return null;
        }
        if (this.elementDefs.isEmpty()) {
            return null;
        }
        return new ArrayList<EnumElementDef>(this.elementDefs);
    }

    public void setElementDefs(List<EnumElementDef> elementDefs) {
        this.elementDefs = new ArrayList<EnumElementDef>(elementDefs);
    }

    public EnumElementDef getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(EnumElementDef defaultValue) {
        this.defaultValue = new EnumElementDef(defaultValue);
    }

    @Override
    public String toString() {
        return "EnumDef{name='" + this.getName() + "', description='" + this.getDescription() + "', version=" + this.getVersion() + ", versionName='" + this.getVersionName() + "', category=" + this.getCategory() + ", GUID='" + this.getGUID() + "', descriptionGUID='" + this.getDescriptionGUID() + "', descriptionWiki='" + this.descriptionWiki + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EnumDef enumDef = (EnumDef)objectToCompare;
        return Objects.equals(this.elementDefs, enumDef.elementDefs) && Objects.equals(this.defaultValue, enumDef.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementDefs, this.defaultValue);
    }
}

