/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.datamanager.api.ExternalReferenceManagerInterface;
import org.odpi.openmetadata.accessservices.datamanager.client.rest.DataManagerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferenceLinkRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferenceResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LinkedExternalReferenceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.externalreferences.ExternalReferenceProperties;

public class ExternalReferenceManagerClient
implements ExternalReferenceManagerInterface {
    private static final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references";
    String serverName;
    String serverPlatformURLRoot;
    AuditLog auditLog = null;
    InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    DataManagerRESTClient restClient;

    public ExternalReferenceManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ExternalReferenceManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public ExternalReferenceManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ExternalReferenceManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new DataManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public ExternalReferenceManagerClient(String serverName, String serverPlatformURLRoot, DataManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    @Override
    public String createExternalReference(String userId, String anchorGUID, String linkId, String linkDescription, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        String parentElementGUIDParameterName = "anchorGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.resourceId";
        this.invalidParameterHandler.validateUserId(userId, "createExternalReference");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "createExternalReference");
        this.invalidParameterHandler.validateObject(properties, "properties", "createExternalReference");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.resourceId", "createExternalReference");
        String urlTemplate = this.serverPlatformURLRoot + urlTemplatePrefix;
        LinkedExternalReferenceRequestBody requestBody = new LinkedExternalReferenceRequestBody();
        requestBody.setAnchorGUID(anchorGUID);
        requestBody.setLinkId(linkId);
        requestBody.setLinkDescription(linkDescription);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalReference", urlTemplate, requestBody, this.serverName, userId);
        return restResult.getGUID();
    }

    @Override
    public void updateExternalReference(String userId, String externalReferenceGUID, boolean isMergeUpdate, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        String elementGUIDParameterName = "externalReferenceGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "updateExternalReference");
        this.invalidParameterHandler.validateObject(properties, "properties", "updateExternalReference");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/{2}?isMergeUpdate={3}";
        this.restClient.callVoidPostRESTCall("updateExternalReference", urlTemplate, properties, this.serverName, userId, externalReferenceGUID, isMergeUpdate);
    }

    @Override
    public void deleteExternalReference(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        String elementGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteExternalReference");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "deleteExternalReference");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/{2}/delete";
        this.restClient.callVoidPostRESTCall("deleteExternalReference", urlTemplate, new NullRequestBody(), this.serverName, userId, externalReferenceGUID);
    }

    @Override
    public void linkExternalReferenceToElement(String userId, String attachedToGUID, String linkId, String linkDescription, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        String attachedToGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "linkExternalReferenceToElement");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "linkExternalReferenceToElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/{2}/link-to/{3}";
        ExternalReferenceLinkRequestBody requestBody = new ExternalReferenceLinkRequestBody();
        requestBody.setLinkId(linkId);
        requestBody.setLinkDescription(linkDescription);
        this.restClient.callVoidPostRESTCall("linkExternalReferenceToElement", urlTemplate, requestBody, this.serverName, userId, externalReferenceGUID, attachedToGUID);
    }

    @Override
    public void unlinkExternalReferenceFromElement(String userId, String attachedToGUID, String externalReferenceGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceFromElement";
        String attachedToGUIDParameterName = "attachedToGUID";
        String externalReferenceGUIDParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unlinkExternalReferenceFromElement");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "unlinkExternalReferenceFromElement");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "unlinkExternalReferenceFromElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/{2}/unlink-from/{3}";
        this.restClient.callVoidPostRESTCall("unlinkExternalReferenceFromElement", urlTemplate, new NullRequestBody(), this.serverName, userId, externalReferenceGUID, attachedToGUID);
    }

    @Override
    public ExternalReferenceElement getExternalReferenceByGUID(String userId, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalReferenceByGUID";
        String guidParameterName = "externalReferenceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getExternalReferenceByGUID");
        this.invalidParameterHandler.validateGUID(externalReferenceGUID, "externalReferenceGUID", "getExternalReferenceByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/{2}";
        ExternalReferenceResponse restResult = this.restClient.callExternalReferenceGetRESTCall("getExternalReferenceByGUID", urlTemplate, this.serverName, userId, externalReferenceGUID);
        return restResult.getElement();
    }

    @Override
    public List<ExternalReferenceElement> findExternalReferencesById(String userId, String resourceId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesById";
        String nameParameterName = "resourceId";
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferencesById");
        this.invalidParameterHandler.validateName(resourceId, "resourceId", "findExternalReferencesById");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferencesById");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/by-resource-id?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(resourceId);
        requestBody.setNamePropertyName("resourceId");
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesPostRESTCall("findExternalReferencesById", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<ExternalReferenceElement> findExternalReferencesByURL(String userId, String url, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findExternalReferencesByURL";
        String nameParameterName = "url";
        this.invalidParameterHandler.validateUserId(userId, "findExternalReferencesByURL");
        this.invalidParameterHandler.validateName(url, "url", "findExternalReferencesByURL");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findExternalReferencesByURL");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/by-url?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(url);
        requestBody.setNamePropertyName("url");
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesPostRESTCall("findExternalReferencesByURL", urlTemplate, requestBody, this.serverName, userId, startFrom, validatedPageSize);
        return restResult.getElements();
    }

    @Override
    public List<ExternalReferenceElement> retrieveAttachedExternalReferences(String userId, String attachedToGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAttachedExternalReferences";
        String guidParameterName = "attachedToGUID";
        this.invalidParameterHandler.validateUserId(userId, "retrieveAttachedExternalReferences");
        this.invalidParameterHandler.validateGUID(attachedToGUID, "attachedToGUID", "retrieveAttachedExternalReferences");
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "retrieveAttachedExternalReferences");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/data-manager/users/{1}/external-references/attached-to/{2}?startFrom={3}&pageSize={4}";
        ExternalReferencesResponse restResult = this.restClient.callExternalReferencesGetRESTCall("retrieveAttachedExternalReferences", urlTemplate, this.serverName, userId, attachedToGUID, startFrom, validatedPageSize);
        return restResult.getElements();
    }
}

