/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.datamanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.datamanager.properties.TemplateProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateRequestBody
extends TemplateProperties {
    private String externalSourceGUID = null;
    private String externalSourceName = null;
    private String parentGUID = null;

    public TemplateRequestBody() {
    }

    public TemplateRequestBody(TemplateRequestBody template) {
        super(template);
        if (template != null) {
            this.externalSourceGUID = template.getExternalSourceGUID();
            this.externalSourceName = template.getExternalSourceName();
            this.parentGUID = template.getParentGUID();
        }
    }

    public TemplateRequestBody(TemplateProperties template) {
        super(template);
    }

    public String getExternalSourceGUID() {
        return this.externalSourceGUID;
    }

    public void setExternalSourceGUID(String externalSourceGUID) {
        this.externalSourceGUID = externalSourceGUID;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    public String getParentGUID() {
        return this.parentGUID;
    }

    public void setParentGUID(String parentGUID) {
        this.parentGUID = parentGUID;
    }

    @Override
    public String toString() {
        return "TemplateRequestBody{qualifiedName='" + this.getQualifiedName() + "', displayName='" + this.getDisplayName() + "', versionIdentifier='" + this.getVersionIdentifier() + "', description='" + this.getDescription() + "', pathName='" + this.getPathName() + "', networkAddress='" + this.getNetworkAddress() + "', externalSourceGUID='" + this.externalSourceGUID + "', externalSourceName='" + this.externalSourceName + "', parentGUID='" + this.parentGUID + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TemplateRequestBody)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TemplateRequestBody that = (TemplateRequestBody)objectToCompare;
        return Objects.equals(this.externalSourceGUID, that.externalSourceGUID) && Objects.equals(this.externalSourceName, that.externalSourceName) && Objects.equals(this.parentGUID, that.parentGUID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalSourceGUID, this.externalSourceName, this.parentGUID);
    }
}

