/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;

public enum IntegrationServiceDescription {
    CATALOG_INTEGRATOR_OMIS(600, ComponentDevelopmentStatus.STABLE, "Catalog Integrator", "Catalog Integrator OMIS", "catalog-integrator", "Exchange metadata with third party data catalogs.", "https://egeria-project.org/services/omis/catalog-integrator/overview/", DeployedImplementationType.CATALOG_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.ASSET_MANAGER_OMAS, PermittedSynchronization.BOTH_DIRECTIONS),
    API_INTEGRATOR_OMIS(601, ComponentDevelopmentStatus.STABLE, "API Integrator", "API Integrator OMIS", "api-integrator", "Exchange metadata with third party API Gateways.", "https://egeria-project.org/services/omis/api-integrator/overview/", DeployedImplementationType.API_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    TOPIC_INTEGRATOR_OMIS(602, ComponentDevelopmentStatus.STABLE, "Topic Integrator", "Topic Integrator OMIS", "topic-integrator", "Exchange metadata with third party event-based brokers.", "https://egeria-project.org/services/omis/topic-integrator/overview/", DeployedImplementationType.TOPIC_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    DISPLAY_INTEGRATOR_OMIS(603, ComponentDevelopmentStatus.STABLE, "Display Integrator", "Display Integrator OMIS", "display-integrator", "Exchange metadata with applications that display data to users.", "https://egeria-project.org/services/omis/display-integrator/overview/", DeployedImplementationType.DISPLAY_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    DATABASE_INTEGRATOR_OMIS(604, ComponentDevelopmentStatus.STABLE, "Database Integrator", "Database Integrator OMIS", "database-integrator", "Extract metadata such as schema, tables and columns from database managers.", "https://egeria-project.org/services/omis/database-integrator/overview/", DeployedImplementationType.DATABASE_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    FILES_INTEGRATOR_OMIS(605, ComponentDevelopmentStatus.STABLE, "Files Integrator", "Files Integrator OMIS", "files-integrator", "Extract metadata about files stored in a file system or file manager.", "https://egeria-project.org/services/omis/files-integrator/overview/", DeployedImplementationType.FILES_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    LINEAGE_INTEGRATOR_OMIS(606, ComponentDevelopmentStatus.STABLE, "Lineage Integrator", "Lineage Integrator OMIS", "lineage-integrator", "Manage exchange of lineage with a third party tool.", "https://egeria-project.org/services/omis/lineage-integrator/overview/", DeployedImplementationType.LINEAGE_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.ASSET_MANAGER_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    ORGANIZATION_INTEGRATOR_OMIS(607, ComponentDevelopmentStatus.STABLE, "Organization Integrator", "Organization Integrator OMIS", "organization-integrator", "Load information about the teams and people in an organization and return collaboration activity.", "https://egeria-project.org/services/omis/organization-integrator/overview/", DeployedImplementationType.ORGANIZATION_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.COMMUNITY_PROFILE_OMAS, PermittedSynchronization.FROM_THIRD_PARTY),
    SECURITY_INTEGRATOR_OMIS(608, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Security Integrator", "Security Integrator OMIS", "security-integrator", "Distribute security properties to security enforcement points.", "https://egeria-project.org/services/omis/security-integrator/overview/", DeployedImplementationType.SECURITY_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.SECURITY_MANAGER_OMAS, PermittedSynchronization.TO_THIRD_PARTY),
    ANALYTICS_INTEGRATOR_OMIS(609, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Analytics Integrator", "Analytics Integrator OMIS", "analytics-integrator", "Exchange metadata with third party analytics tools.", "https://egeria-project.org/services/omis/analytics-integrator/overview/", DeployedImplementationType.ANALYTICS_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.DATA_SCIENCE_OMAS, PermittedSynchronization.BOTH_DIRECTIONS),
    SEARCH_INTEGRATOR_OMIS(610, ComponentDevelopmentStatus.DEPRECATED, "Search Integrator", "Search Integrator OMIS", "search-integrator", "Store metadata with a third party technology that is focused on search efficiency.", "https://egeria-project.org/services/omis/search-integrator/overview/", DeployedImplementationType.SEARCH_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.ASSET_CONSUMER_OMAS, PermittedSynchronization.BOTH_DIRECTIONS),
    INFRASTRUCTURE_INTEGRATOR_OMIS(611, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Infrastructure Integrator", "Infrastructure Integrator OMIS", "infrastructure-integrator", "Exchange information relating to IT infrastructure such as hosts, platforms, servers, server capabilities and services.", "https://egeria-project.org/services/omis/infrastructure-integrator/overview/", DeployedImplementationType.INFRASTRUCTURE_INTEGRATION_CONNECTOR.getDeployedImplementationType(), AccessServiceDescription.IT_INFRASTRUCTURE_OMAS, PermittedSynchronization.BOTH_DIRECTIONS);

    private final int integrationServiceCode;
    private final ComponentDevelopmentStatus integrationServiceDevelopmentStatus;
    private final String integrationServiceName;
    private final String integrationServiceFullName;
    private final String integrationServiceURLMarker;
    private final String integrationServiceDescription;
    private final String integrationServiceWiki;
    private final String connectorDeployedImplementationType;
    private final AccessServiceDescription integrationServicePartnerOMAS;
    private final PermittedSynchronization defaultPermittedSynchronization;

    private IntegrationServiceDescription(int integrationServiceCode, ComponentDevelopmentStatus integrationServiceDevelopmentStatus, String integrationServiceName, String integrationServiceFullName, String integrationServiceURLMarker, String integrationServiceDescription, String integrationServiceWiki, String connectorDeployedImplementationType, AccessServiceDescription integrationServicePartnerOMAS, PermittedSynchronization defaultPermittedSynchronization) {
        this.integrationServiceCode = integrationServiceCode;
        this.integrationServiceDevelopmentStatus = integrationServiceDevelopmentStatus;
        this.integrationServiceName = integrationServiceName;
        this.integrationServiceFullName = integrationServiceFullName;
        this.integrationServiceURLMarker = integrationServiceURLMarker;
        this.integrationServiceDescription = integrationServiceDescription;
        this.integrationServiceWiki = integrationServiceWiki;
        this.connectorDeployedImplementationType = connectorDeployedImplementationType;
        this.integrationServicePartnerOMAS = integrationServicePartnerOMAS;
        this.defaultPermittedSynchronization = defaultPermittedSynchronization;
    }

    public static IntegrationServiceDescription getIntegrationServiceDefinition(int integrationServiceCode) {
        for (IntegrationServiceDescription description : IntegrationServiceDescription.values()) {
            if (integrationServiceCode != description.getIntegrationServiceCode()) continue;
            return description;
        }
        return null;
    }

    public int getIntegrationServiceCode() {
        return this.integrationServiceCode;
    }

    public ComponentDevelopmentStatus getIntegrationServiceDevelopmentStatus() {
        return this.integrationServiceDevelopmentStatus;
    }

    public String getIntegrationServiceName() {
        return this.integrationServiceName;
    }

    public String getIntegrationServiceFullName() {
        return this.integrationServiceFullName;
    }

    public String getIntegrationServiceURLMarker() {
        return this.integrationServiceURLMarker;
    }

    public String getIntegrationServiceDescription() {
        return this.integrationServiceDescription;
    }

    public String getIntegrationServiceWiki() {
        return this.integrationServiceWiki;
    }

    public AccessServiceDescription getIntegrationServicePartnerOMAS() {
        return this.integrationServicePartnerOMAS;
    }

    public String getConnectorDeployedImplementationType() {
        return this.connectorDeployedImplementationType;
    }

    public PermittedSynchronization getDefaultPermittedSynchronization() {
        return this.defaultPermittedSynchronization;
    }
}

