/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ffdc;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.slf4j.Logger;

public class RESTCallLogger {
    private final Logger log;
    private final String serviceName;

    public RESTCallLogger(Logger log, String serviceName) {
        this.log = log;
        this.serviceName = serviceName;
    }

    public RESTCallToken logRESTCall(String serverName, String userId, String methodName) {
        if (this.log.isDebugEnabled()) {
            RESTCallToken token = new RESTCallToken(this.serviceName, serverName, userId, methodName);
            this.log.debug(token.getRESTCallStartText());
            return token;
        }
        return null;
    }

    public RESTCallToken logRESTCall(String serverName, String methodName) {
        if (this.log.isDebugEnabled()) {
            RESTCallToken token = new RESTCallToken(this.serviceName, serverName, methodName);
            this.log.debug(token.getRESTCallStartText());
            return token;
        }
        return null;
    }

    public void setUserId(RESTCallToken token, String userId) {
        if (this.log.isDebugEnabled() && token != null) {
            token.setUserId(userId);
        }
    }

    public void logRESTCallReturn(RESTCallToken token, String response) {
        if (this.log.isDebugEnabled()) {
            if (token != null) {
                this.log.debug(token.getRESTCallReturnText(response));
            } else {
                this.log.debug(this.serviceName + ": returned with response " + response);
            }
        }
    }
}

