/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;

public enum SecretsStoreConfigurationProperty {
    SECRETS_COLLECTION_NAME("secretsCollectionName", "The name used to identify the collection of properties that a particular connector is using.", DataType.STRING.getName(), "DatabricksServerOne", true);

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;
    public final boolean isPlaceholder;

    private SecretsStoreConfigurationProperty(String name, String description, String dataType, String example, boolean isPlaceholder) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
        this.isPlaceholder = isPlaceholder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public boolean isPlaceholder() {
        return this.isPlaceholder;
    }

    public static List<String> getStaticSecretStoreRecognizedConfProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(SECRETS_COLLECTION_NAME.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getStaticSecretStoreConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> recognizedConfigurationProperties = new ArrayList<ConfigurationPropertyType>();
        recognizedConfigurationProperties.add(SECRETS_COLLECTION_NAME.getConfigurationPropertyType());
        return recognizedConfigurationProperties;
    }

    public static List<String> getRecognizedConfigurationProperties() {
        ArrayList<String> configurationPropertyTypes = new ArrayList<String>();
        for (SecretsStoreConfigurationProperty configurationProperty : SecretsStoreConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getName());
        }
        return configurationPropertyTypes;
    }

    public static List<ConfigurationPropertyType> getConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        for (SecretsStoreConfigurationProperty configurationProperty : SecretsStoreConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getConfigurationPropertyType());
        }
        return configurationPropertyTypes;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        ConfigurationPropertyType configurationPropertyType = new ConfigurationPropertyType();
        configurationPropertyType.setName(this.name);
        configurationPropertyType.setDescription(this.description);
        configurationPropertyType.setDataType(this.dataType);
        configurationPropertyType.setExample(this.example);
        configurationPropertyType.setRequired(this.isPlaceholder);
        return configurationPropertyType;
    }

    public String toString() {
        return "ConfigurationProperty{ name=" + this.name + "}";
    }
}

