/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddedConnection
extends PropertyBase {
    protected int position = 0;
    protected String displayName = null;
    protected Map<String, Object> arguments = null;
    protected Connection embeddedConnection = null;

    public EmbeddedConnection() {
    }

    public EmbeddedConnection(EmbeddedConnection template) {
        super(template);
        if (template != null) {
            this.position = template.getPosition();
            this.displayName = template.getDisplayName();
            this.arguments = template.getArguments();
            this.embeddedConnection = template.getEmbeddedConnection();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public Connection getEmbeddedConnection() {
        if (this.embeddedConnection == null) {
            return null;
        }
        return new Connection(this.embeddedConnection);
    }

    public void setEmbeddedConnection(Connection embeddedConnection) {
        this.embeddedConnection = embeddedConnection;
    }

    public String toString() {
        return "EmbeddedConnection{position=" + this.position + ", displayName='" + this.displayName + "', arguments=" + this.arguments + ", embeddedConnection=" + this.embeddedConnection + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EmbeddedConnection that = (EmbeddedConnection)objectToCompare;
        return this.position == that.position && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.embeddedConnection, that.embeddedConnection);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position, this.displayName, this.arguments, this.embeddedConnection);
    }
}

