/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.DuplicateManagementInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceActionProcessInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceCompletionInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.client.WatchDogEventInterface;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PortType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessContainmentType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class GovernanceActionContext
implements GovernanceContext,
ProvisioningGovernanceContext,
RemediationGovernanceContext,
TriageGovernanceContext,
VerificationGovernanceContext,
WatchdogGovernanceContext {
    private final String userId;
    private final String requestType;
    private final Map<String, String> requestParameters;
    private final String requesterUserId;
    private final List<RequestSourceElement> requestSourceElements;
    private final List<ActionTargetElement> actionTargetElements;
    private volatile CompletionStatus completionStatus = null;
    private final String engineActionGUID;
    private final ActionControlInterface actionControlClient;
    private final DuplicateManagementInterface duplicateManagementClient;
    private final GovernanceActionProcessInterface governanceActionProcessClient;
    private final GovernanceCompletionInterface governanceCompletionClient;
    private final WatchDogEventInterface watchDogEventClient;
    private final OpenMetadataClient openMetadataClient;
    private final OpenMetadataStore openMetadataStore;
    private final GovernanceConfiguration governanceConfiguration;
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final MessageFormatter messageFormatter = new MessageFormatter();

    public GovernanceActionContext(String userId, String engineActionGUID, String requestType, Map<String, String> requestParameters, String requesterUserId, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, OpenMetadataClient openMetadataClient, GovernanceConfiguration governanceConfiguration, ActionControlInterface actionControlClient, DuplicateManagementInterface duplicateManagementClient, GovernanceActionProcessInterface governanceActionProcessClient, GovernanceCompletionInterface governanceCompletionClient, WatchDogEventInterface watchdogEventClient) {
        this.userId = userId;
        this.engineActionGUID = engineActionGUID;
        this.requestType = requestType;
        this.requestParameters = requestParameters;
        this.requesterUserId = requesterUserId;
        this.requestSourceElements = requestSourceElements;
        this.actionTargetElements = actionTargetElements;
        this.openMetadataClient = openMetadataClient;
        this.governanceConfiguration = governanceConfiguration;
        this.actionControlClient = actionControlClient;
        this.duplicateManagementClient = duplicateManagementClient;
        this.governanceActionProcessClient = governanceActionProcessClient;
        this.governanceCompletionClient = governanceCompletionClient;
        this.watchDogEventClient = watchdogEventClient;
        this.openMetadataStore = new OpenMetadataStore(openMetadataClient, userId, engineActionGUID);
    }

    @Override
    public String getEngineActionGUID() {
        return this.engineActionGUID;
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public String getRequesterUserId() {
        return this.requesterUserId;
    }

    @Override
    public List<RequestSourceElement> getRequestSourceElements() {
        return this.requestSourceElements;
    }

    @Override
    public List<ActionTargetElement> getActionTargetElements() {
        return this.actionTargetElements;
    }

    @Override
    public OpenMetadataStore getOpenMetadataStore() {
        return this.openMetadataStore;
    }

    @Override
    public int getMaxPageSize() {
        return this.openMetadataClient.getMaxPagingSize();
    }

    @Override
    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createIncidentReport(this.userId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, this.engineActionGUID);
    }

    @Override
    public void updateActionTargetStatus(String actionTargetGUID, EngineActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceCompletionClient.updateActionTargetStatus(this.userId, actionTargetGUID, status, startDate, completionDate, completionMessage);
    }

    @Override
    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.governanceCompletionClient.recordCompletionStatus(this.userId, this.engineActionGUID, this.requestParameters, status, outputGuards, null, null);
    }

    @Override
    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.governanceCompletionClient.recordCompletionStatus(this.userId, this.engineActionGUID, this.requestParameters, status, outputGuards, newActionTargets, null);
    }

    @Override
    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.recordCompletionStatus(status, outputGuards, newRequestParameters, newActionTargets, (String)null);
    }

    @Override
    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        HashMap<String, String> combinedRequestParameters = new HashMap<String, String>();
        if (this.requestParameters != null) {
            combinedRequestParameters.putAll(this.requestParameters);
        }
        if (newRequestParameters != null) {
            combinedRequestParameters.putAll(newRequestParameters);
        }
        this.governanceCompletionClient.recordCompletionStatus(this.userId, this.engineActionGUID, combinedRequestParameters, status, outputGuards, newActionTargets, completionMessage);
    }

    @Override
    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets, AuditLogMessageDefinition completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (completionMessage != null) {
            this.recordCompletionStatus(status, outputGuards, newRequestParameters, newActionTargets, this.messageFormatter.getFormattedMessage(completionMessage));
        } else {
            this.recordCompletionStatus(status, outputGuards, newRequestParameters, newActionTargets);
        }
    }

    @Override
    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    @Override
    public String createGovernanceEngine(String governanceEngineType, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.createGovernanceEngine(this.userId, governanceEngineType, qualifiedName, displayName, description);
    }

    @Override
    public GovernanceEngineElement getGovernanceEngineByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getGovernanceEngineByGUID(this.userId, guid);
    }

    @Override
    public GovernanceEngineElement getGovernanceEngineByName(String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getGovernanceEngineByName(this.userId, name);
    }

    @Override
    public List<GovernanceEngineElement> getAllGovernanceEngines(String governanceEngineType, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getAllGovernanceEngines(this.userId, governanceEngineType, startingFrom, maximumResults);
    }

    @Override
    public void updateGovernanceEngine(String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.updateGovernanceEngine(this.userId, guid, qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, extendedProperties);
    }

    @Override
    public void deleteGovernanceEngine(String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.deleteGovernanceEngine(this.userId, guid, qualifiedName);
    }

    @Override
    public String createGovernanceService(String governanceServiceType, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.createGovernanceService(this.userId, governanceServiceType, qualifiedName, displayName, description, connection);
    }

    @Override
    public GovernanceServiceElement getGovernanceServiceByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getGovernanceServiceByGUID(this.userId, guid);
    }

    @Override
    public GovernanceServiceElement getGovernanceServiceByName(String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getGovernanceServiceByName(this.userId, name);
    }

    @Override
    public List<GovernanceServiceElement> getAllGovernanceServices(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getAllGovernanceServices(this.userId, startingFrom, maximumResults);
    }

    @Override
    public List<String> getGovernanceServiceRegistrations(String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getGovernanceServiceRegistrations(this.userId, governanceServiceGUID);
    }

    @Override
    public void updateGovernanceService(String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.updateGovernanceService(this.userId, guid, qualifiedName, displayName, description, connection, additionalProperties, extendedProperties);
    }

    @Override
    public void deleteGovernanceService(String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.deleteGovernanceService(this.userId, guid, qualifiedName);
    }

    @Override
    public void registerGovernanceServiceWithEngine(String governanceEngineGUID, String governanceServiceGUID, String requestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.registerGovernanceServiceWithEngine(this.userId, governanceEngineGUID, governanceServiceGUID, requestType, requestParameters);
    }

    @Override
    public void registerGovernanceServiceWithEngine(String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.registerGovernanceServiceWithEngine(this.userId, governanceEngineGUID, governanceServiceGUID, governanceRequestType, serviceRequestType, requestParameters);
    }

    @Override
    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getRegisteredGovernanceService(this.userId, governanceEngineGUID, governanceServiceGUID);
    }

    @Override
    public List<RegisteredGovernanceServiceElement> getRegisteredGovernanceServices(String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getRegisteredGovernanceServices(this.userId, governanceEngineGUID, startingFrom, maximumResults);
    }

    @Override
    public void unregisterGovernanceServiceFromEngine(String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.unregisterGovernanceServiceFromEngine(this.userId, governanceEngineGUID, governanceServiceGUID);
    }

    @Override
    public String createIntegrationGroup(IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.createIntegrationGroup(this.userId, properties);
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getIntegrationGroupByGUID(this.userId, guid);
    }

    @Override
    public IntegrationGroupElement getIntegrationGroupByName(String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getIntegrationGroupByName(this.userId, name);
    }

    @Override
    public List<IntegrationGroupElement> getAllIntegrationGroups(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getAllIntegrationGroups(this.userId, startingFrom, maximumResults);
    }

    @Override
    public void updateIntegrationGroup(String guid, boolean isMergeUpdate, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.updateIntegrationGroup(this.userId, guid, isMergeUpdate, properties);
    }

    @Override
    public void deleteIntegrationGroup(String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.deleteIntegrationGroup(this.userId, guid, qualifiedName);
    }

    @Override
    public String createIntegrationConnector(IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.createIntegrationConnector(this.userId, properties);
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByGUID(String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getIntegrationConnectorByGUID(this.userId, guid);
    }

    @Override
    public IntegrationConnectorElement getIntegrationConnectorByName(String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getIntegrationConnectorByName(this.userId, name);
    }

    @Override
    public List<IntegrationConnectorElement> getAllIntegrationConnectors(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getAllIntegrationConnectors(this.userId, startingFrom, maximumResults);
    }

    @Override
    public List<String> getIntegrationConnectorRegistrations(String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getIntegrationConnectorRegistrations(this.userId, integrationConnectorGUID);
    }

    @Override
    public void updateIntegrationConnector(String guid, boolean isMergeUpdate, IntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.updateIntegrationConnector(this.userId, guid, isMergeUpdate, properties);
    }

    @Override
    public void deleteIntegrationConnector(String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.deleteIntegrationConnector(this.userId, guid, qualifiedName);
    }

    @Override
    public void registerIntegrationConnectorWithGroup(String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.registerIntegrationConnectorWithGroup(this.userId, integrationGroupGUID, integrationConnectorGUID, properties);
    }

    @Override
    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getRegisteredIntegrationConnector(this.userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String integrationGroupGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getRegisteredIntegrationConnectors(this.userId, integrationGroupGUID, startingFrom, maximumResults);
    }

    @Override
    public void unregisterIntegrationConnectorFromGroup(String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.unregisterIntegrationConnectorFromGroup(this.userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @Override
    public String addCatalogTarget(String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.addCatalogTarget(this.userId, integrationConnectorGUID, metadataElementGUID, properties);
    }

    @Override
    public void updateCatalogTarget(String catalogTargetGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.updateCatalogTarget(this.userId, catalogTargetGUID, properties);
    }

    @Override
    public CatalogTarget getCatalogTarget(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getCatalogTarget(this.userId, relationshipGUID);
    }

    @Override
    public List<CatalogTarget> getCatalogTargets(String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.governanceConfiguration.getCatalogTargets(this.userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @Override
    public void removeCatalogTarget(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.governanceConfiguration.removeCatalogTarget(this.userId, relationshipGUID);
    }

    private ElementProperties packBasicProperties(String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties, String methodName) throws InvalidParameterException {
        String qualifiedNamePropertyName = "qualifiedName";
        String namePropertyName = "name";
        String versionIdentifierPropertyName = "versionIdentifier";
        String descriptionPropertyName = "description";
        this.propertyHelper.validateMandatoryName(qualifiedName, "qualifiedName", methodName);
        ElementProperties properties = this.propertyHelper.addStringProperty(extendedProperties, "qualifiedName", qualifiedName);
        properties = this.propertyHelper.addStringProperty(properties, "name", name);
        properties = this.propertyHelper.addStringProperty(properties, "versionIdentifier", versionIdentifier);
        properties = this.propertyHelper.addStringProperty(properties, "description", description);
        return properties;
    }

    @Override
    public String createAsset(String assetTypeName, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset(simple)";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createAsset(simple)");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, assetTypeName, ElementStatus.ACTIVE, null, null, true, null, null, properties, null, null, null, true);
    }

    @Override
    public String createAsset(String assetTypeName, String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createAsset");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, assetTypeName, ElementStatus.ACTIVE, null, null, true, null, null, properties, null, null, null, true);
    }

    @Override
    public String createAssetFromTemplate(String templateGUID, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createAssetFromTemplate");
        return this.openMetadataClient.createMetadataElementFromTemplate(this.userId, OpenMetadataType.ASSET.typeName, null, true, null, null, templateGUID, properties, null, null, null, null, false);
    }

    @Override
    public String createAssetFromTemplate(String assetTypeName, String templateGUID, String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        String metadataElementTypeName = OpenMetadataType.ASSET.typeName;
        if (assetTypeName != null) {
            metadataElementTypeName = assetTypeName;
        }
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createAssetFromTemplate");
        return this.openMetadataClient.createMetadataElementFromTemplate(this.userId, metadataElementTypeName, null, true, null, null, templateGUID, properties, null, null, null, null, false);
    }

    @Override
    public String createProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createProcess");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, true, null, null, properties, null, null, null, true);
    }

    @Override
    public String createProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createProcess");
        properties = this.propertyHelper.addStringProperty(properties, "formula", formula);
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, true, null, null, properties, null, null, null, true);
    }

    @Override
    public String createProcessFromTemplate(String templateGUID, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createProcessFromTemplate");
        return this.openMetadataClient.createMetadataElementFromTemplate(this.userId, OpenMetadataType.PROCESS.typeName, null, true, null, null, templateGUID, properties, null, null, null, null, false);
    }

    @Override
    public String createProcessFromTemplate(String templateGUID, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createProcessFromTemplate");
        properties = this.propertyHelper.addStringProperty(properties, "formula", formula);
        return this.openMetadataClient.createMetadataElementFromTemplate(this.userId, OpenMetadataType.PROCESS.typeName, null, true, null, null, templateGUID, properties, null, null, null, null, false);
    }

    @Override
    public String createChildProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description, String parentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createChildProcess(simple)";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createChildProcess(simple)");
        ElementProperties relationshipProperties = this.propertyHelper.addEnumProperty(null, "containmentType", "ProcessContainmentType", ProcessContainmentType.OWNED.getName());
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, parentGUID, false, null, null, properties, parentGUID, "ProcessHierarchy", relationshipProperties, true);
    }

    @Override
    public String createChildProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties, String parentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createChildProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createChildProcess");
        properties = this.propertyHelper.addStringProperty(properties, "formula", formula);
        ElementProperties relationshipProperties = this.propertyHelper.addEnumProperty(null, "containmentType", "ProcessContainmentType", ProcessContainmentType.OWNED.getName());
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, parentGUID, false, null, null, properties, parentGUID, "ProcessHierarchy", relationshipProperties, true);
    }

    @Override
    public String createPort(String processGUID, String qualifiedName, String displayName, PortType portType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        String processGUIDParameterName = "processGUID";
        this.propertyHelper.validateGUID(processGUID, "processGUID", "createProcess");
        ElementProperties properties = this.packBasicProperties(qualifiedName, null, null, null, null, "createProcess");
        properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName);
        properties = this.propertyHelper.addEnumProperty(properties, "portType", "PortType", portType.getName());
        return this.openMetadataClient.createMetadataElementInStore(this.userId, "PortImplementation", ElementStatus.ACTIVE, null, processGUID, false, null, null, properties, processGUID, "ProcessPort", null, true);
    }

    @Override
    public String createLineageRelationship(String sourceElementGUID, String targetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLineageMapping";
        String lineageMappingTypeName = "LineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String targetElementGUIDParameterName = "targetElementGUID";
        this.propertyHelper.validateGUID(sourceElementGUID, "sourceElementGUID", "createLineageMapping");
        this.propertyHelper.validateGUID(targetElementGUID, "targetElementGUID", "createLineageMapping");
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, "LineageMapping", sourceElementGUID, targetElementGUID, true, false, null, null, null, new Date());
    }

    @Override
    public String createLineageRelationship(String relationshipName, String sourceElementGUID, String qualifiedName, String description, String formula, String targetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLineageRelationship";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String targetElementGUIDParameterName = "targetElementGUID";
        this.propertyHelper.validateGUID(sourceElementGUID, "sourceElementGUID", "createLineageRelationship");
        this.propertyHelper.validateGUID(targetElementGUID, "targetElementGUID", "createLineageRelationship");
        ElementProperties relationshipProperties = this.propertyHelper.addStringProperty(null, "qualifiedName", qualifiedName);
        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, "description", description);
        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, "formula", formula);
        String lineageRelationshipTypeName = "LineageMapping";
        if (relationshipName != null) {
            lineageRelationshipTypeName = relationshipName;
        }
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, lineageRelationshipTypeName, sourceElementGUID, targetElementGUID, true, false, null, null, relationshipProperties, new Date());
    }

    @Override
    public String createMetadataElement(String metadataElementTypeName, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, metadataElementTypeName, ElementStatus.ACTIVE, null, null, properties);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, null, null, metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    @Override
    public String createMetadataElement(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties);
    }

    @Override
    public void updateMetadataElement(String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementInStore(this.userId, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateMetadataElementStatus(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementStatusInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    @Override
    public void updateMetadataElementEffectivity(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementEffectivityInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void deleteMetadataElement(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteMetadataElementInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void classifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, null, null, properties, effectiveTime);
    }

    @Override
    public void classifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void reclassifyMetadataElement(String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.reclassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateClassificationStatus(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateClassificationEffectivityInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void declassifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.declassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public String createRelatedElements(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, null, null, properties, effectiveTime);
    }

    @Override
    public String createRelatedElements(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElements(String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsInStore(this.userId, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElementsStatus(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsEffectivityInStore(this.userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void deleteRelatedElements(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteRelatedElementsInStore(this.userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void linkElementsAsPeerDuplicates(String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.duplicateManagementClient.linkElementsAsPeerDuplicates(this.userId, metadataElement1GUID, metadataElement2GUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, setKnownDuplicate);
    }

    @Override
    public void linkConsolidatedDuplicate(String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.duplicateManagementClient.linkConsolidatedDuplicate(this.userId, consolidatedElementGUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, sourceElementGUIDs);
    }

    @Override
    public String openToDo(String toDoQualifiedName, String title, String instructions, String toDoType, int priority, Date dueDate, String assignToGUID, String actionTargetGUID, String actionTargetName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignToGUID";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignToGUID, "assignToGUID", "openToDo");
        NewActionTarget actionTarget = new NewActionTarget();
        actionTarget.setActionTargetGUID(actionTargetGUID);
        actionTarget.setActionTargetName(actionTargetName);
        ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
        actionTargets.add(actionTarget);
        return this.openMetadataClient.openToDo(this.userId, toDoQualifiedName, title, instructions, toDoType, priority, dueDate, null, assignToGUID, null, null, actionTargets);
    }

    @Override
    public void registerListener(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) throws InvalidParameterException {
        this.watchDogEventClient.registerListener(listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
    }

    @Override
    public void disconnectListener() {
        this.watchDogEventClient.disconnectListener();
    }

    @Override
    public String initiateEngineAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlClient.initiateEngineAction(this.userId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, null, startTime, governanceEngineName, requestType, requestParameters, null, null, this.engineActionGUID, governanceEngineName);
    }

    @Override
    public String initiateEngineAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlClient.initiateEngineAction(this.userId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, null, startTime, governanceEngineName, requestType, requestParameters, processName, null, this.engineActionGUID, governanceEngineName);
    }

    @Override
    public String initiateGovernanceActionType(String governanceActionTypeQualifiedName, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, Map<String, String> requestParameters, String originatorServiceName, String originatorEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlClient.initiateGovernanceActionType(this.userId, governanceActionTypeQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, originatorServiceName, originatorEngineName);
    }

    @Override
    public String initiateGovernanceActionProcess(String processQualifiedName, Map<String, String> requestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.actionControlClient.initiateGovernanceActionProcess(this.userId, processQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, null, null);
    }

    public String toString() {
        return "GovernanceActionContext{userId='" + this.userId + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", requestSourceElements=" + this.requestSourceElements + ", actionTargetElements=" + this.actionTargetElements + ", completionStatus=" + this.completionStatus + ", engineActionGUID='" + this.engineActionGUID + "', actionControlClient=" + this.actionControlClient + ", duplicateManagementClient=" + this.duplicateManagementClient + ", governanceActionProcessClient=" + this.governanceActionProcessClient + ", governanceCompletionClient=" + this.governanceCompletionClient + ", watchDogEventClient=" + this.watchDogEventClient + ", openMetadataClient=" + this.openMetadataClient + ", openMetadataStore=" + this.openMetadataStore + ", propertyHelper=" + this.propertyHelper + "}";
    }
}

