/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataAttributeTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefGallery;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;

public class OpenMetadataStore {
    protected final OpenMetadataClient openMetadataClient;
    private final String userId;
    private String externalSourceGUID;
    private String externalSourceName;
    private final String originatorGUID;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;
    private boolean useCurrentEffectiveTime = false;

    public OpenMetadataStore(OpenMetadataClient openMetadataClient, String userId, String externalSourceGUID, String externalSourceName, String originatorGUID) {
        this.openMetadataClient = openMetadataClient;
        this.userId = userId;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.originatorGUID = originatorGUID;
    }

    public OpenMetadataStore(OpenMetadataClient openMetadataClient, String userId, String originatorGUID) {
        this.openMetadataClient = openMetadataClient;
        this.userId = userId;
        this.externalSourceGUID = null;
        this.externalSourceName = null;
        this.originatorGUID = originatorGUID;
    }

    public int getMaxPagingSize() {
        return this.openMetadataClient.getMaxPagingSize();
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public boolean isUseCurrentEffectiveTime() {
        return this.useCurrentEffectiveTime;
    }

    public void setUseCurrentEffectiveTime(boolean useCurrentEffectiveTime) {
        this.useCurrentEffectiveTime = useCurrentEffectiveTime;
    }

    private Date getEffectiveTime() {
        if (this.useCurrentEffectiveTime) {
            return new Date();
        }
        return null;
    }

    public void setExternalSourceIds(String externalSourceGUID, String externalSourceName) {
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
    }

    public OpenMetadataTypeDefGallery getAllTypes() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.getAllTypes(this.userId);
    }

    public List<OpenMetadataTypeDef> findTypeDefsByCategory(OpenMetadataTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.findTypeDefsByCategory(this.userId, category);
    }

    public List<OpenMetadataAttributeTypeDef> findAttributeTypeDefsByCategory(OpenMetadataAttributeTypeDefCategory category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.findAttributeTypeDefsByCategory(this.userId, category);
    }

    public List<OpenMetadataTypeDef> findTypesByExternalID(String standard, String organization, String identifier) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.findTypesByExternalId(this.userId, standard, organization, identifier);
    }

    public OpenMetadataTypeDef getTypeDefByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.getTypeDefByGUID(this.userId, guid);
    }

    public OpenMetadataAttributeTypeDef getAttributeTypeDefByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.getAttributeTypeDefByGUID(this.userId, guid);
    }

    public OpenMetadataTypeDef getTypeDefByName(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.getTypeDefByName(this.userId, name);
    }

    public OpenMetadataAttributeTypeDef getAttributeTypeDefByName(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openMetadataClient.getAttributeTypeDefByName(this.userId, name);
    }

    public OpenMetadataElement getMetadataElementByGUID(String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementByGUID(this.userId, elementGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementByUniqueName(this.userId, uniqueName, uniquePropertyName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public OpenMetadataElement getLineageElementByUniqueName(String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementByUniqueName(this.userId, uniqueName, uniquePropertyName, true, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public OpenMetadataElement getDeletedElementByUniqueName(String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getDeletedElementByUniqueName(this.userId, uniqueName, uniquePropertyName);
    }

    public String getMetadataElementGUIDByUniqueName(String uniqueName, String uniquePropertyName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementGUIDByUniqueName(this.userId, uniqueName, uniquePropertyName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findMetadataElementsWithString(this.userId, searchString, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, String typeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findMetadataElementsWithString(this.userId, searchString, typeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String elementGUID, int startingAtEnd, String relationshipTypeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getRelatedMetadataElements(this.userId, elementGUID, startingAtEnd, relationshipTypeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public RelatedMetadataElement getRelatedMetadataElement(String elementGUID, int startingAtEnd, String relationshipTypeName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getRelatedMetadataElement(this.userId, elementGUID, startingAtEnd, relationshipTypeName, this.forLineage, this.forDuplicateProcessing, effectiveTime);
    }

    public List<OpenMetadataRelationship> getMetadataElementRelationships(String metadataElementAtEnd1GUID, String metadataElementAtEnd2GUID, String relationshipTypeName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementRelationships(this.userId, metadataElementAtEnd1GUID, metadataElementAtEnd2GUID, relationshipTypeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findMetadataElements(this.userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, asOfTime, matchClassifications, sequencingProperty, sequencingOrder, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public List<OpenMetadataRelationship> findRelationshipsBetweenMetadataElements(String relationshipTypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.findRelationshipsBetweenMetadataElements(this.userId, relationshipTypeName, searchProperties, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startFrom, pageSize);
    }

    public OpenMetadataRelationship getRelationshipByGUID(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getRelationshipByGUID(this.userId, relationshipGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, initialStatus, null, null, properties);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String createMetadataElementFromTemplate(String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String getMetadataElementFromTemplate(String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataElementFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public void updateMetadataElementInStore(String metadataElementGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public void updateMetadataElementStatusInStore(String metadataElementGUID, ElementStatus newElementStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementStatusInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, newElementStatus, this.getEffectiveTime());
    }

    public void updateMetadataElementEffectivityInStore(String metadataElementGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, this.getEffectiveTime());
    }

    public void deleteMetadataElementInStore(String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public void archiveMetadataElementInStore(String metadataElementGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.archiveMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, archiveProperties, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, null, null, properties, this.getEffectiveTime());
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, this.getEffectiveTime());
    }

    public void reclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.reclassifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public void updateClassificationEffectivityInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateClassificationEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, this.getEffectiveTime());
    }

    public void declassifyMetadataElementInStore(String metadataElementGUID, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.declassifyMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public String createRelatedElementsInStore(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, this.getEffectiveTime());
    }

    public void updateRelatedElementsInStore(String relationshipGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public void updateRelatedElementsEffectivityInStore(String relationshipGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsEffectivityInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, this.getEffectiveTime());
    }

    public void deleteRelatedElementsInStore(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, relationshipGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createIncidentReport(this.userId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, originatorGUID);
    }

    public String openToDo(String qualifiedName, String title, String instructions, String todoCategory, int priority, Date dueDate, Map<String, String> additionalProperties, String assignTo, String sponsorGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.openToDo(this.userId, qualifiedName, title, instructions, todoCategory, priority, dueDate, additionalProperties, assignTo, sponsorGUID, this.originatorGUID, actionTargets);
    }

    public void setUpValidMetadataValue(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.setUpValidMetadataValue(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapName(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.setUpValidMetadataMapName(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapValue(String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.setUpValidMetadataMapValue(this.userId, typeName, propertyName, mapName, validMetadataValue);
    }

    public void clearValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.clearValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.clearValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.clearValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public boolean validateMetadataValue(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.validateMetadataValue(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapName(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.validateMetadataMapName(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapValue(String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.validateMetadataMapValue(this.userId, typeName, propertyName, mapName, actualValue);
    }

    public ValidMetadataValue getValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public List<ValidMetadataValueDetail> getValidMetadataValues(String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getValidMetadataValues(this.userId, typeName, propertyName, startFrom, pageSize);
    }

    public List<ValidMetadataValue> getConsistentMetadataValues(String typeName, String propertyName, String mapName, String preferredValue, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getConsistentMetadataValues(this.userId, typeName, propertyName, mapName, preferredValue, startFrom, pageSize);
    }

    public void addExternalIdentifier(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.addExternalIdentifier(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifierProperties);
    }

    public void updateExternalIdentifier(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateExternalIdentifier(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifierProperties);
    }

    public void removeExternalIdentifier(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.removeExternalIdentifier(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier);
    }

    public void confirmSynchronization(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.confirmSynchronization(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier);
    }

    public List<ElementHeader> getElementsForExternalIdentifier(String externalScopeGUID, String externalScopeName, String externalIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getElementsForExternalIdentifier(this.userId, externalScopeGUID, externalScopeName, externalIdentifier, startFrom, pageSize);
    }

    public void validateExternalIdentifier(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.validateExternalIdentifier(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName, elementExternalIdentifier);
    }

    public List<MetadataCorrelationHeader> getMetadataCorrelationHeaders(String externalScopeGUID, String externalScopeName, String openMetadataElementGUID, String openMetadataElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getMetadataCorrelationHeaders(this.userId, externalScopeGUID, externalScopeName, openMetadataElementGUID, openMetadataElementTypeName);
    }

    public Map<String, Map<String, String>> getVendorProperties(String openMetadataElementGUID, String openMetadataElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.getVendorProperties(this.userId, openMetadataElementGUID, openMetadataElementTypeName);
    }
}

