/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;

public class CollectionConverter<B>
extends OpenMetadataConverterBase<B> {
    public CollectionConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                CollectionProperties collectionProperties = new CollectionProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    collectionProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    collectionProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    collectionProperties.setName(this.removeName(elementProperties));
                    collectionProperties.setDescription(this.removeDescription(elementProperties));
                    collectionProperties.setCollectionType(this.removeCollectionType(elementProperties));
                    collectionProperties.setEffectiveFrom(openMetadataElement.getEffectiveFromTime());
                    collectionProperties.setEffectiveTo(openMetadataElement.getEffectiveToTime());
                    collectionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    collectionProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(collectionProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof CollectionElement) {
                CollectionElement bean = (CollectionElement)returnBean;
                CollectionProperties collectionProperties = new CollectionProperties();
                OpenMetadataElement openMetadataElement = relatedMetadataElement.getElement();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    collectionProperties.setQualifiedName(this.removeQualifiedName(elementProperties));
                    collectionProperties.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
                    collectionProperties.setName(this.removeName(elementProperties));
                    collectionProperties.setDescription(this.removeDescription(elementProperties));
                    collectionProperties.setCollectionType(this.removeCollectionType(elementProperties));
                    collectionProperties.setEffectiveFrom(openMetadataElement.getEffectiveFromTime());
                    collectionProperties.setEffectiveTo(openMetadataElement.getEffectiveToTime());
                    collectionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    collectionProperties.setExtendedProperties(this.getRemainingExtendedProperties(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(collectionProperties);
                bean.setRelatedElement(super.getRelatedElement(beanClass, relatedMetadataElement, methodName));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement element, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, element, methodName);
        if (returnBean instanceof CollectionElement) {
            CollectionElement bean = (CollectionElement)returnBean;
            bean.setRelatedElement(super.getRelatedElement(beanClass, element, relationship, methodName));
        }
        return returnBean;
    }
}

