/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.iterator;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;

public class RelatedElementsIterator
extends IntegrationIterator {
    private final String parentGUID;
    private final String parentRelationshipTypeName;
    private final int parentAtEnd;

    public RelatedElementsIterator(String metadataCollectionGUID, String metadataCollectionQualifiedName, String catalogTargetName, String connectorName, String parentGUID, String parentRelationshipTypeName, int parentAtEnd, String metadataTypeName, OpenMetadataAccess openMetadataAccess, PermittedSynchronization targetPermittedSynchronization, int maxPageSize, AuditLog auditLog) {
        super(metadataCollectionGUID, metadataCollectionQualifiedName, catalogTargetName, connectorName, metadataTypeName, openMetadataAccess, targetPermittedSynchronization, maxPageSize, auditLog);
        this.parentGUID = parentGUID;
        this.parentRelationshipTypeName = parentRelationshipTypeName;
        this.parentAtEnd = parentAtEnd;
    }

    @Override
    protected boolean fillCache() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.elementCache == null || this.elementCache.isEmpty()) {
            List<RelatedMetadataElement> relatedMetadataElementList = this.openMetadataAccess.getRelatedMetadataElements(this.parentGUID, this.parentAtEnd, this.parentRelationshipTypeName, this.startFrom, this.maxPageSize);
            this.elementCache = this.getElementCache(relatedMetadataElementList);
            this.startFrom += this.maxPageSize;
        }
        return this.elementCache != null;
    }

    private List<OpenMetadataElement> getElementCache(List<RelatedMetadataElement> relatedMetadataElementList) {
        if (relatedMetadataElementList != null) {
            ArrayList<OpenMetadataElement> results = new ArrayList<OpenMetadataElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElementList) {
                if (relatedMetadataElement == null) continue;
                results.add(relatedMetadataElement.getElement());
            }
            return results;
        }
        return null;
    }
}

