/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;

public enum PlaceholderProperty {
    HOST_IDENTIFIER("hostIdentifier", "The host IP address or domain name.", "string", "coconet.com"),
    HOST_URL("hostURL", "The host IP address or domain name of the server with the HTTP protocol prefix.", "string", "https://coconet.com"),
    PORT_NUMBER("portNumber", "The number of the port to use to connect to a service.", "string", "1234"),
    SERVER_NETWORK_ADDRESS("serverNetworkAddress", "The network address of the server.", "string", "http://localhost:8080"),
    API_OPERATION("apiOperation", "The name of the operation to append onto the server host name/port number, or set it to an empty string if not needed.", "string", "/api/v1/lineage"),
    CONNECTION_USER_ID("connectionUserId", "The userId to store in the userId attribute of the connection.", "string", "user1"),
    SERVER_NAME("serverName", "The name of the server being catalogued.", "string", "myServer"),
    SERVER_ID("serverId", "The local identifier of the server being catalogued.", "string", "myServer"),
    SCHEMA_NAME("schemaName", "The name of the schema being catalogued.", "string", "MyServer.schema"),
    DISPLAY_NAME("displayName", "The display name is used to identify the element.  It does not need to be unique, but it should help someone know what the element is about.", "string", "myDataSet"),
    DESCRIPTION("description", "The description of the element to help a consumer understand its content and purpose.", "string", "This file contains a week's worth of patient data for the Teddy Bear Drop Foot clinical trial."),
    VERSION_IDENTIFIER("versionIdentifier", "The string identifier for the element.  This is typically of the form Vx.y.z where x is the major version number, y is the minor version number, and z is an option patch identifier.", "string", "V1.0"),
    SECRETS_STORE("secretsStorePathName", "The full path name to the secrets store file where the secrets collection for this server is located.", "string", "loading-bay/secrets/default.omsecrets"),
    FORMULA("formula", "The formula used to populate the data set.", "string", null),
    FORMULA_TYPE("formulaType", "The language/format used in the data set's formula.", "string", null),
    FILE_SYSTEM_NAME("fileSystemName", "The unique name for the file system that this file/directory belongs.  It may be a machine name or a URL to a remote file store.", "string", "/a/b/c/myFile.txt"),
    FORMAT("format", "The format standard used in the file system.", "string", "APFS"),
    ENCRYPTION("encryption", "Is encryption enabled on this file system? If known, what type of encryption?", "string", "Not Enabled"),
    DIRECTORY_PATH_NAME("directoryPathName", "The full path name of the directory including the parent directory names and optional file system name, if applicable", "string", "/a/b/myFiles"),
    DIRECTORY_NAME("directoryName", "The name of the leaf directory, without its enclosing directories.", "string", "myFiles"),
    FILE_PATH_NAME("filePathName", "The full path name of the file including the directory names, file name and optional file extension, if applicable.", "string", "/a/b/myFiles/myFile.txt"),
    FILE_NAME("fileName", "The short name of the file with its extension but without the directory names.", "string", "myFile.txt"),
    FILE_TYPE("fileType", "The logical file type of the file.", "string", "Text File"),
    FILE_EXTENSION("fileExtension", "The postfix identifier in the file name that indicates the format of the file.", "string", "txt"),
    FILE_ENCODING("fileEncoding", "The encoding scheme used on the file.", "string", "JSON"),
    PROGRAMMING_LANGUAGE("programmingLanguage", "The programming language used to encode the file.", "string", "Java"),
    EMBEDDED_METADATA("embeddedMetadata", "Descriptive metadata values embedded within the file.", "map<string, string>", null),
    CREATION_DATE("dateCreated", "The date that the file was created.", "string", null),
    LAST_UPDATE_DATE("dateLastModified", "The date that the file was last changed.", "string", null),
    LAST_ACCESSED_DATE("dateLastAccessed", "The date that the file was last read.", "string", null),
    RECEIVED_DATE("dateReceived", "The date/time that the data/resource was received.", "string", "2024-07-10T16:11:09");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private PlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getHostPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_URL.getPlaceholderType());
        placeholderPropertyTypes.add(PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(DISPLAY_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getHTTPEndpointPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_URL.getPlaceholderType());
        placeholderPropertyTypes.add(PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(API_OPERATION.getPlaceholderType());
        placeholderPropertyTypes.add(SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getServerWithUserIdOnlyPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_URL.getPlaceholderType());
        placeholderPropertyTypes.add(PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(CONNECTION_USER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getSecretServerPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_URL.getPlaceholderType());
        placeholderPropertyTypes.add(PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(SECRETS_STORE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getFileSystemPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(FORMAT.getPlaceholderType());
        placeholderPropertyTypes.add(ENCRYPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getDataStorePlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(HOST_URL.getPlaceholderType());
        placeholderPropertyTypes.add(PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(DISPLAY_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getDataSetPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(DISPLAY_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(FORMULA.getPlaceholderType());
        placeholderPropertyTypes.add(FORMULA_TYPE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getDataFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getMediaFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        placeholderPropertyTypes.add(EMBEDDED_METADATA.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getFolderPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DIRECTORY_PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DIRECTORY_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getSoftwareFilesPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(FILE_SYSTEM_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_TYPE.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_EXTENSION.getPlaceholderType());
        placeholderPropertyTypes.add(FILE_ENCODING.getPlaceholderType());
        placeholderPropertyTypes.add(PROGRAMMING_LANGUAGE.getPlaceholderType());
        placeholderPropertyTypes.add(VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

