/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CriticalityLevel implements OpenMetadataEnum
{
    UNCLASSIFIED(0, "4c2c0370-973f-479c-9251-d400d55ad7e8", "Unclassified", "There is no assessment of the criticality for this data.", true),
    MARGINAL(1, "75cf926a-57f9-494d-8b08-995bd0dd7a72", "Marginal", "The data is of minor importance to the organization.", false),
    IMPORTANT(2, "e78e4e87-9fa1-4b81-be4e-ca6b499d9898", "Important", "The data is important to the running of the organization.", false),
    CRITICAL(3, "a0b6807e-6440-48a7-b76c-847f9e95767a", "Critical", "The data is critical to the operation of the organization.", false),
    CATASTROPHIC(4, "e6effba2-3861-47f3-9738-dbc452532892", "Catastrophic", "The data is so important that its loss is catastrophic, putting the future of the organization in doubt.", false),
    OTHER(99, "81044dc1-ae06-404b-83d7-1c4180daa09e", "Other", "Another criticality level.", false);

    private static final String ENUM_TYPE_GUID = "22bcbf49-83e1-4432-b008-e09a8f842a1e";
    private static final String ENUM_TYPE_NAME = "CriticalityLevel";
    private static final String ENUM_DESCRIPTION = "Defines how important a data item is to the organization.";
    private static final String ENUM_DESCRIPTION_GUID = "96925394-0ded-4c0a-9080-6668706ab317";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0421-Governance-Classification-Levels/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private CriticalityLevel(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER.name, null);
    }

    public String toString() {
        return "CriticalityLevel{name='" + this.name + "}";
    }
}

