/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataClassAssignmentStatus implements OpenMetadataEnum
{
    DISCOVERED("4074e762-ef65-4705-aa37-940b42bde97c", 0, "Discovered", "The term assignment was discovered by an automated process.", false),
    PROPOSED("cf3477d9-8373-4894-b7e1-63722faca3cb", 1, "Proposed", "The term assignment was proposed by a subject-matter expert.", false),
    IMPORTED("2fae7977-e463-4f03-a9fe-a3765faf8f5e", 2, "Imported", "The term assignment was imported from another metadata system.", false),
    VALIDATED("b9dc8d2c-342e-4596-aa66-34c133731017", 3, "Validated", "The term assignment has been validated and approved by a subject-matter expert.", false),
    DEPRECATED("519ca599-6675-4675-b9ce-e71262714216", 4, "Deprecated", "The term assignment should no longer be used.", false),
    OBSOLETE("cc18444b-c202-4c13-80fd-4caea1d2549e", 5, "Obsolete", "The term assignment must no longer be used.", false),
    OTHER("6e5493c7-cd87-4de6-9570-6c9471f56f1f", 99, "Other", "The term assignment is in a locally defined state.", false);

    private static final String ENUM_TYPE_GUID = "2611892f-0527-478f-8843-a3aa2b9abb47";
    private static final String ENUM_TYPE_NAME = "DataClassAssignmentStatus";
    private static final String ENUM_DESCRIPTION = "Defines the provenance and confidence of a data class assignment.";
    private static final String ENUM_DESCRIPTION_GUID = "36d8a171-1b8d-4f7e-88f1-f89b9566f33a";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/5/0540-Data-Classes/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private DataClassAssignmentStatus(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.DATA_CLASS_ASSIGNMENT_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.DATA_CLASS_ASSIGNMENT_STATUS.name, null);
    }

    public String toString() {
        return "DataClassAssignmentStatus{name='" + this.name + "}";
    }
}

