/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OperationalStatus implements OpenMetadataEnum
{
    DISABLED(0, "5c4e3e26-ea46-4f59-bedd-65393db3eac2", "Disabled", "The component is deployed but not operational.", true),
    ENABLED(1, "36e3644a-9d36-437b-b71c-04d4304d3e4a", "Enabled", "The component is operational.", false);

    private static final String ENUM_TYPE_GUID = "24e1e33e-9250-4a6c-8b07-05c7adec3a1d";
    private static final String ENUM_TYPE_NAME = "OperationalStatus";
    private static final String ENUM_DESCRIPTION = "Defines whether a component is operational.";
    private static final String ENUM_DESCRIPTION_GUID = "92aca118-02c0-4df3-a4e2-95391a3566fd";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0037-Software-Server-Platforms/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private OperationalStatus(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SORT_ORDER.name, null);
    }

    public String toString() {
        return "OperationalStatus : " + this.name;
    }
}

