/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ProcessStatus {
    UNKNOWN(0, 0, "<Unknown>", "Unknown process status.", ElementStatus.UNKNOWN),
    DRAFT(1, 1, "Draft", "The process is incomplete.", ElementStatus.DRAFT),
    PROPOSED(2, 3, "Proposed", "The process is in review.", ElementStatus.PROPOSED),
    APPROVED(3, 4, "Approved", "The process is approved.", ElementStatus.APPROVED),
    ACTIVE(4, 15, "Active", "The process is approved and in use.", ElementStatus.ACTIVE);

    private final int ordinal;
    private final int openTypeOrdinal;
    private final String name;
    private final String description;
    private final ElementStatus elementStatus;

    private ProcessStatus(int ordinal, int openTypeOrdinal, String name, String description, ElementStatus elementStatus) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
        this.elementStatus = elementStatus;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ElementStatus getElementStatus() {
        return this.elementStatus;
    }

    public String toString() {
        return "ProcessStatus{ordinal=" + this.ordinal + ", openTypeOrdinal=" + this.openTypeOrdinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

