/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementVersions;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementControlHeader {
    public static final long CURRENT_AUDIT_HEADER_VERSION = 1L;
    private long headerVersion = 0L;
    private ElementStatus status = null;
    private ElementType type = null;
    private ElementOrigin origin = null;
    private ElementVersions versions = null;

    public ElementControlHeader() {
    }

    public ElementControlHeader(ElementControlHeader template) {
        if (template != null) {
            this.headerVersion = template.getHeaderVersion();
            this.status = template.getStatus();
            this.type = template.getType();
            this.origin = template.getOrigin();
            this.versions = template.getVersions();
        }
    }

    public long getHeaderVersion() {
        return this.headerVersion;
    }

    public void setHeaderVersion(long headerVersion) {
        this.headerVersion = headerVersion;
    }

    public ElementStatus getStatus() {
        return this.status;
    }

    public void setStatus(ElementStatus status) {
        this.status = status;
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public ElementOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(ElementOrigin origin) {
        this.origin = origin;
    }

    public ElementVersions getVersions() {
        return this.versions;
    }

    public void setVersions(ElementVersions versions) {
        this.versions = versions;
    }

    public String toString() {
        return "ElementControlHeader{status=" + this.status + ", type=" + this.type + ", origin=" + this.origin + ", versions=" + this.versions + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ElementControlHeader that = (ElementControlHeader)objectToCompare;
        return this.status == that.status && Objects.equals(this.type, that.type) && Objects.equals(this.origin, that.origin) && Objects.equals(this.versions, that.versions);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.type, this.origin, this.versions);
    }
}

