/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.governance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FindAssetOriginProperties
extends FindProperties {
    private String organizationGUID = null;
    private String businessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public FindAssetOriginProperties() {
    }

    public FindAssetOriginProperties(FindAssetOriginProperties template) {
        if (template != null) {
            this.organizationGUID = template.getOrganizationGUID();
            this.businessCapabilityGUID = template.getBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    public String getBusinessCapabilityGUID() {
        return this.businessCapabilityGUID;
    }

    public void setBusinessCapabilityGUID(String businessCapabilityGUID) {
        this.businessCapabilityGUID = businessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "FindAssetOriginProperties{organizationGUID='" + this.organizationGUID + "', businessCapabilityGUID='" + this.businessCapabilityGUID + "', otherOriginValues=" + this.otherOriginValues + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof FindAssetOriginProperties)) {
            return false;
        }
        FindAssetOriginProperties that = (FindAssetOriginProperties)objectToCompare;
        return Objects.equals(this.organizationGUID, that.organizationGUID) && Objects.equals(this.businessCapabilityGUID, that.businessCapabilityGUID) && Objects.equals(this.otherOriginValues, that.otherOriginValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOrganizationGUID(), this.getBusinessCapabilityGUID(), this.getOtherOriginValues());
    }
}

