/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ClassificationAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataClassAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RelationshipAdviceAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileLogAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SemanticAnnotation;

public class AnnotationStore {
    private final OpenMetadataClient openMetadataStore;
    private final String userId;
    private final String externalSourceGUID;
    private final String externalSourceName;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;
    private boolean useCurrentEffectiveTime = false;
    private String surveyReportGUID;
    private String reportQualifiedName;
    private String reportDisplayName;
    private String surveyDescription;
    private String surveyPurpose;
    private String analysisStep = null;
    private static final PropertyHelper propertyHelper = new PropertyHelper();
    private final AnnotationConverter<Annotation> converter;

    public AnnotationStore(String userId, String assetGUID, OpenMetadataClient openMetadataStore, String externalSourceGUID, String externalSourceName, String reportQualifiedName, String reportDisplayName, String surveyDescription, String surveyPurpose, String engineActionGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.userId = userId;
        this.openMetadataStore = openMetadataStore;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.reportQualifiedName = reportQualifiedName;
        this.reportDisplayName = reportDisplayName;
        this.surveyDescription = surveyDescription;
        this.surveyPurpose = surveyPurpose;
        this.converter = new AnnotationConverter("Survey Action Framework (SAF)", openMetadataStore.getServerName());
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, reportQualifiedName);
        properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.DISPLAY_NAME.name, reportDisplayName);
        properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.DESCRIPTION.name, surveyDescription);
        properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.PURPOSE.name, surveyPurpose);
        Date startDate = new Date();
        properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.START_DATE.name, startDate);
        this.surveyReportGUID = openMetadataStore.createMetadataElementInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.SURVEY_REPORT.typeName, ElementStatus.ACTIVE, null, assetGUID, false, null, null, properties, assetGUID, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, null, true);
        if (this.surveyReportGUID != null && engineActionGUID != null) {
            openMetadataStore.createRelatedElementsInStore(userId, externalSourceGUID, externalSourceName, OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeName, engineActionGUID, this.surveyReportGUID, this.forLineage, this.forDuplicateProcessing, null, null, null, this.getEffectiveTime());
        }
    }

    public AnnotationStore(String userId, OpenMetadataClient openMetadataStore, String surveyReportGUID, String externalSourceGUID, String externalSourceName) {
        this.userId = userId;
        this.openMetadataStore = openMetadataStore;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.reportQualifiedName = null;
        this.reportDisplayName = null;
        this.surveyDescription = null;
        this.surveyPurpose = null;
        this.surveyReportGUID = surveyReportGUID;
        this.converter = new AnnotationConverter("Survey Action Framework (SAF)", openMetadataStore.getServerName());
    }

    protected void setSurveyReportGUID(String surveyReportGUID) {
        this.surveyReportGUID = surveyReportGUID;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public boolean isUseCurrentEffectiveTime() {
        return this.useCurrentEffectiveTime;
    }

    public void setUseCurrentEffectiveTime(boolean useCurrentEffectiveTime) {
        this.useCurrentEffectiveTime = useCurrentEffectiveTime;
    }

    private Date getEffectiveTime() {
        if (this.useCurrentEffectiveTime) {
            return new Date();
        }
        return null;
    }

    public String getSurveyReportGUID() {
        return this.surveyReportGUID;
    }

    public String getAnalysisStep() {
        return this.analysisStep;
    }

    public void setAnalysisStep(String analysisStep) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.analysisStep = analysisStep;
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.ANALYSIS_STEP.name, analysisStep);
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public String getReportQualifiedName() {
        return this.reportQualifiedName;
    }

    public void setReportQualifiedName(String reportName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.reportQualifiedName = reportName;
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, this.reportQualifiedName);
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public String getReportDisplayName() {
        return this.reportDisplayName;
    }

    public void setReportDisplayName(String reportName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.reportDisplayName = reportName;
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.DISPLAY_NAME.name, this.reportDisplayName);
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public String getSurveyDescription() {
        return this.surveyDescription;
    }

    public void setSurveyDescription(String surveyDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.surveyDescription = surveyDescription;
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.DESCRIPTION.name, surveyDescription);
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public String getSurveyPurpose() {
        return this.surveyPurpose;
    }

    public void setSurveyPurpose(String surveyPurpose) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.surveyPurpose = surveyPurpose;
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.PURPOSE.name, this.surveyDescription);
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public void setCompletionMessage(String completionMessage) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties properties = propertyHelper.addStringProperty(null, OpenMetadataProperty.COMPLETION_MESSAGE.name, completionMessage);
        properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.COMPLETION_DATE.name, new Date());
        this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, this.surveyReportGUID, false, this.forLineage, this.forDuplicateProcessing, properties, this.getEffectiveTime());
    }

    public List<Annotation> getAnnotationsForElement(String elementGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotationsForElement";
        List<RelatedMetadataElement> relatedMetadataElements = this.openMetadataStore.getRelatedMetadataElements(this.userId, elementGUID, 1, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startingFrom, maximumResults);
        return this.getRelatedAnnotationBeans(relatedMetadataElements, "getAnnotationsForElement");
    }

    public List<Annotation> getNewAnnotations(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNewAnnotations";
        List<RelatedMetadataElement> relatedMetadataElements = this.openMetadataStore.getRelatedMetadataElements(this.userId, this.surveyReportGUID, 1, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startingFrom, maximumResults);
        return this.getRelatedAnnotationBeans(relatedMetadataElements, "getNewAnnotations");
    }

    public List<Annotation> getExtendedAnnotations(String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        List<RelatedMetadataElement> relatedMetadataElements = this.openMetadataStore.getRelatedMetadataElements(this.userId, annotationGUID, 1, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), startingFrom, maximumResults);
        return this.getRelatedAnnotationBeans(relatedMetadataElements, "getExtendedAnnotations");
    }

    public Annotation getAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotation";
        OpenMetadataElement openMetadataElement = this.openMetadataStore.getMetadataElementByGUID(this.userId, annotationGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
        return this.getAnnotationBean(openMetadataElement, "getAnnotation");
    }

    public String addAnnotation(Annotation annotation, String associatedElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID;
        AnnotationBuilder builder = this.getAnnotationBuilder(annotation);
        if (builder != null && (annotationGUID = this.openMetadataStore.createMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, builder.getOpenMetadataTypeName(), ElementStatus.ACTIVE, null, this.surveyReportGUID, false, null, null, builder.getElementProperties(), this.surveyReportGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, null, true)) != null) {
            if (builder.getDataProfileDataGUIDs() != null) {
                for (String dataProfileDataGUID : builder.getDataProfileDataGUIDs()) {
                    if (dataProfileDataGUID == null) continue;
                    this.openMetadataStore.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.typeName, annotationGUID, dataProfileDataGUID, this.forLineage, this.forDuplicateProcessing, null, null, null, this.getEffectiveTime());
                }
            }
            if (builder.getRequestForActionTargetGUIDs() != null) {
                for (String requestForActionTargetGUID : builder.getRequestForActionTargetGUIDs()) {
                    if (requestForActionTargetGUID == null) continue;
                    this.openMetadataStore.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, OpenMetadataType.REQUEST_FOR_ACTION_TARGET.typeName, annotationGUID, requestForActionTargetGUID, this.forLineage, this.forDuplicateProcessing, null, null, null, this.getEffectiveTime());
                }
            }
            if (associatedElementGUID != null) {
                this.openMetadataStore.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, associatedElementGUID, annotationGUID, this.forLineage, this.forDuplicateProcessing, null, null, null, this.getEffectiveTime());
            }
            return annotationGUID;
        }
        return null;
    }

    public String addAnnotationExtension(String parentAnnotationGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUID = this.addAnnotation(annotation, null);
        if (annotationGUID != null && parentAnnotationGUID != null) {
            this.openMetadataStore.createRelatedElementsInStore(this.userId, this.externalSourceGUID, this.externalSourceName, OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName, parentAnnotationGUID, annotationGUID, this.forLineage, this.forDuplicateProcessing, null, null, null, this.getEffectiveTime());
        }
        return null;
    }

    public void updateAnnotation(Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AnnotationBuilder builder;
        String guid = null;
        if (annotation != null && annotation.getElementHeader() != null) {
            guid = annotation.getElementHeader().getGUID();
        }
        if ((builder = this.getAnnotationBuilder(annotation)) != null) {
            this.openMetadataStore.updateMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, guid, true, this.forLineage, this.forDuplicateProcessing, builder.getElementProperties(), this.getEffectiveTime());
        }
    }

    public void deleteAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.deleteMetadataElementInStore(this.userId, this.externalSourceGUID, this.externalSourceName, annotationGUID, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime());
    }

    private AnnotationBuilder getAnnotationBuilder(Annotation annotation) {
        if (annotation != null) {
            AnnotationBuilder builder = new AnnotationBuilder(annotation.getAnnotationType(), annotation.getSummary(), annotation.getConfidenceLevel(), annotation.getExpression(), annotation.getExplanation(), annotation.getAnalysisStep(), annotation.getJsonProperties(), annotation.getAdditionalProperties(), annotation.getOpenMetadataTypeName(), annotation.getExtendedProperties());
            if (annotation instanceof ClassificationAnnotation) {
                ClassificationAnnotation classificationAnnotation = (ClassificationAnnotation)annotation;
                builder.setClassificationSubtypeProperties(OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName, classificationAnnotation.getCandidateClassifications());
            } else if (annotation instanceof DataClassAnnotation) {
                DataClassAnnotation dataClassAnnotation = (DataClassAnnotation)annotation;
                builder.setDataClassSubtypeProperties(OpenMetadataType.DATA_CLASS_ANNOTATION.typeName, dataClassAnnotation.getCandidateDataClassGUIDs(), dataClassAnnotation.getMatchingValues(), dataClassAnnotation.getNonMatchingValues());
            } else if (annotation instanceof ResourceProfileLogAnnotation) {
                ResourceProfileLogAnnotation resourceProfileLogAnnotation = (ResourceProfileLogAnnotation)annotation;
                builder.setDataProfileLogSubtypeProperties(OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName, resourceProfileLogAnnotation.getResourceProfileLogGUIDs());
            } else if (annotation instanceof ResourceProfileAnnotation) {
                ResourceProfileAnnotation resourceProfileAnnotation = (ResourceProfileAnnotation)annotation;
                builder.setDataProfileSubtypeProperties(OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, resourceProfileAnnotation.getProfilePropertyNames(), resourceProfileAnnotation.getLength(), resourceProfileAnnotation.getInferredDataType(), resourceProfileAnnotation.getInferredFormat(), resourceProfileAnnotation.getInferredLength(), resourceProfileAnnotation.getInferredPrecision(), resourceProfileAnnotation.getInferredScale(), resourceProfileAnnotation.getProfileStartDate(), resourceProfileAnnotation.getProfileEndDate(), resourceProfileAnnotation.getProfileProperties(), resourceProfileAnnotation.getProfileFlags(), resourceProfileAnnotation.getProfileDates(), resourceProfileAnnotation.getProfileCounts(), resourceProfileAnnotation.getProfileDoubles(), resourceProfileAnnotation.getValueList(), resourceProfileAnnotation.getValueCount(), resourceProfileAnnotation.getValueRangeFrom(), resourceProfileAnnotation.getValueRangeTo(), resourceProfileAnnotation.getAverageValue());
            } else if (annotation instanceof ResourcePhysicalStatusAnnotation) {
                ResourcePhysicalStatusAnnotation dataSourcePhysicalStatusAnnotation = (ResourcePhysicalStatusAnnotation)annotation;
                builder.setDataSourcePhysicalStatusSubtypeProperties(OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName, dataSourcePhysicalStatusAnnotation.getResourceProperties(), dataSourcePhysicalStatusAnnotation.getCreateTime(), dataSourcePhysicalStatusAnnotation.getModifiedTime(), dataSourcePhysicalStatusAnnotation.getSize(), dataSourcePhysicalStatusAnnotation.getEncoding());
            } else if (annotation instanceof ResourceMeasureAnnotation) {
                ResourceMeasureAnnotation resourceMeasureAnnotation = (ResourceMeasureAnnotation)annotation;
                builder.setDataSourceMeasurementSubtypeProperties(OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, resourceMeasureAnnotation.getResourceProperties());
            } else if (annotation instanceof QualityAnnotation) {
                QualityAnnotation qualityAnnotation = (QualityAnnotation)annotation;
                builder.setQualitySubtypeProperties(OpenMetadataType.QUALITY_ANNOTATION.typeName, qualityAnnotation.getQualityDimension(), qualityAnnotation.getQualityScore());
            } else if (annotation instanceof RelationshipAdviceAnnotation) {
                RelationshipAdviceAnnotation relationshipAdviceAnnotation = (RelationshipAdviceAnnotation)annotation;
                builder.setRelationshipAdviceSubtypeProperties(OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName, relationshipAdviceAnnotation.getRelatedEntityGUID(), relationshipAdviceAnnotation.getRelationshipTypeName(), relationshipAdviceAnnotation.getRelationshipProperties());
            } else if (annotation instanceof RequestForActionAnnotation) {
                RequestForActionAnnotation requestForActionAnnotation = (RequestForActionAnnotation)annotation;
                builder.setRequestForActionSubtypeProperties(OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName, requestForActionAnnotation.getSurveyActivity(), requestForActionAnnotation.getActionRequested(), requestForActionAnnotation.getActionProperties(), requestForActionAnnotation.getActionTargetGUIDs());
            } else if (annotation instanceof SchemaAnalysisAnnotation) {
                SchemaAnalysisAnnotation schemaAnalysisAnnotation = (SchemaAnalysisAnnotation)annotation;
                builder.setSchemaAnalysisSubTypeProperties(OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName, schemaAnalysisAnnotation.getSchemaName(), schemaAnalysisAnnotation.getSchemaName());
            } else if (annotation instanceof SemanticAnnotation) {
                SemanticAnnotation semanticAnnotation = (SemanticAnnotation)annotation;
                builder.setSemanticSubTypeProperties(OpenMetadataType.SEMANTIC_ANNOTATION.typeName, semanticAnnotation.getInformalTerm(), semanticAnnotation.getInformalTopic(), semanticAnnotation.getCandidateGlossaryTermGUIDs(), semanticAnnotation.getCandidateGlossaryCategoryGUIDs());
            }
            return builder;
        }
        return null;
    }

    private List<Annotation> getAnnotationBeans(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (openMetadataElements != null) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                annotations.add(this.getAnnotationBean(openMetadataElement, methodName));
            }
            return annotations;
        }
        return null;
    }

    private List<Annotation> getRelatedAnnotationBeans(List<RelatedMetadataElement> openMetadataElements, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (openMetadataElements != null) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (RelatedMetadataElement openMetadataElement : openMetadataElements) {
                annotations.add(this.getAnnotationBean(openMetadataElement.getElement(), methodName));
            }
            return annotations;
        }
        return null;
    }

    private Annotation getAnnotationBean(OpenMetadataElement annotationElement, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (annotationElement != null) {
            List<RelatedMetadataElement> relationships = this.openMetadataStore.getRelatedMetadataElements(this.userId, annotationElement.getElementGUID(), 0, null, this.forLineage, this.forDuplicateProcessing, this.getEffectiveTime(), 0, 0);
            return this.converter.getAnnotationBean(Annotation.class, annotationElement, relationships, methodName);
        }
        return null;
    }

    static class AnnotationConverter<B>
    extends OpenMetadataConverterBase<B> {
        static final PropertyHelper propertyHelper = new PropertyHelper();

        public AnnotationConverter(String serviceName, String serverName) {
            super(propertyHelper, serviceName, serverName);
        }

        protected Annotation getAnnotationBean(Class<B> beanClass, OpenMetadataElement annotationElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            if (annotationElement != null && annotationElement.getType() != null) {
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName)) {
                    return this.getNewClassificationAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.DATA_CLASS_ANNOTATION.typeName)) {
                    return this.getNewDataClassAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName)) {
                    return this.getNewDataProfileAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName)) {
                    return this.getNewDataProfileLogAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName)) {
                    return this.getNewDataSourcePhysicalStatusAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName)) {
                    return this.getNewDataSourceMeasurementAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.QUALITY_ANNOTATION.typeName)) {
                    return this.getNewQualityAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName)) {
                    return this.getNewRelatedMetadataElementAdviceAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName)) {
                    return this.getNewRequestForActionAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName)) {
                    return this.getNewSchemaAnalysisAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.SEMANTIC_ANNOTATION.typeName)) {
                    return this.getNewSemanticAnnotation(beanClass, annotationElement, relationships, methodName);
                }
                if (propertyHelper.isTypeOf(annotationElement, OpenMetadataType.ANNOTATION.typeName)) {
                    return this.getNewAnnotation(beanClass, annotationElement, relationships, methodName);
                }
            }
            return null;
        }

        private Annotation getNewClassificationAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                ClassificationAnnotation annotation = new ClassificationAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setCandidateClassifications(this.removeCandidateClassifications(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewDataClassAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                DataClassAnnotation annotation = new DataClassAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setCandidateDataClassGUIDs(this.removeCandidateDataClassGUIDs(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewDataProfileAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                ResourceProfileAnnotation annotation = new ResourceProfileAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setLength(this.removeLength(remainingProperties));
                annotation.setInferredDataType(this.removeInferredDataType(remainingProperties));
                annotation.setInferredFormat(this.removeInferredFormat(remainingProperties));
                annotation.setInferredLength(this.removeInferredLength(remainingProperties));
                annotation.setInferredPrecision(this.removeInferredPrecision(remainingProperties));
                annotation.setInferredScale(this.removeInferredScale(remainingProperties));
                annotation.setProfileStartDate(this.removeProfileStartDate(remainingProperties));
                annotation.setProfileEndDate(this.removeProfileEndDate(remainingProperties));
                annotation.setProfileProperties(this.removeProfileProperties(remainingProperties));
                annotation.setProfileFlags(this.removeProfileFlags(remainingProperties));
                annotation.setProfileCounts(this.removeProfileCounts(remainingProperties));
                annotation.setProfileDoubles(this.removeProfileDoubles(remainingProperties));
                annotation.setValueList(this.removeValueList(remainingProperties));
                annotation.setValueCount(this.removeValueCount(remainingProperties));
                annotation.setValueRangeFrom(this.removeValueRangeFrom(remainingProperties));
                annotation.setValueRangeTo(this.removeValueRangeTo(remainingProperties));
                annotation.setAverageValue(this.removeAverageValue(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewDataProfileLogAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                ResourceProfileLogAnnotation annotation = new ResourceProfileLogAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                ArrayList<String> dataProfileLogs = new ArrayList<String>();
                if (relationships != null) {
                    for (RelatedMetadataElement relationship : relationships) {
                        OpenMetadataElement logFile;
                        if (relationship == null || !propertyHelper.isTypeOf(relationship, OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.typeName) || (logFile = relationship.getElement()) == null) continue;
                        dataProfileLogs.add(logFile.getElementGUID());
                    }
                }
                annotation.setResourceProfileLogGUIDs(dataProfileLogs);
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewDataSourceMeasurementAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                ResourceMeasureAnnotation annotation = new ResourceMeasureAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setResourceProperties(this.removeResourceProperties(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewDataSourcePhysicalStatusAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                ResourcePhysicalStatusAnnotation annotation = new ResourcePhysicalStatusAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setResourceProperties(this.removeResourceProperties(remainingProperties));
                annotation.setCreateTime(this.removeResourceCreateTime(remainingProperties));
                annotation.setModifiedTime(this.removeResourceUpdateTime(remainingProperties));
                annotation.setLastAccessedTime(this.removeResourceLastAccessedTime(remainingProperties));
                annotation.setSize(this.removeSize(remainingProperties));
                annotation.setEncoding(this.removeEncoding(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewQualityAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                QualityAnnotation annotation = new QualityAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setQualityDimension(this.removeQualityDimension(remainingProperties));
                annotation.setQualityScore(this.removeQualityScore(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewRelatedMetadataElementAdviceAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                RelationshipAdviceAnnotation annotation = new RelationshipAdviceAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setRelatedEntityGUID(this.removeRelatedEntityGUID(remainingProperties));
                annotation.setRelationshipTypeName(this.removeRelationshipTypeName(remainingProperties));
                annotation.setRelationshipProperties(this.removeRelationshipProperties(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewRequestForActionAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                RequestForActionAnnotation annotation = new RequestForActionAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setSurveyActivity(this.removeActionSourceName(remainingProperties));
                annotation.setActionRequested(this.removeActionRequested(remainingProperties));
                annotation.setActionProperties(this.removeActionProperties(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                ArrayList<String> actionTargetGUIDS = new ArrayList<String>();
                if (relationships != null) {
                    for (RelatedMetadataElement relationship : relationships) {
                        OpenMetadataElement logFile;
                        if (relationship == null || !propertyHelper.isTypeOf(relationship, OpenMetadataType.REQUEST_FOR_ACTION_TARGET.typeName) || (logFile = relationship.getElement()) == null) continue;
                        actionTargetGUIDS.add(logFile.getElementGUID());
                    }
                }
                annotation.setActionTargetGUIDs(actionTargetGUIDS);
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewSchemaAnalysisAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                SchemaAnalysisAnnotation annotation = new SchemaAnalysisAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setSchemaName(this.removeSchemaName(remainingProperties));
                annotation.setSchemaTypeName(this.removeSchemaType(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewSemanticAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                SemanticAnnotation annotation = new SemanticAnnotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setInformalTerm(this.removeInformalTerm(remainingProperties));
                annotation.setCandidateGlossaryTermGUIDs(this.removeCandidateGlossaryTermGUIDs(remainingProperties));
                annotation.setInformalTopic(this.removeInformalTopic(remainingProperties));
                annotation.setCandidateGlossaryCategoryGUIDs(this.removeCandidateGlossaryCategoryGUIDs(remainingProperties));
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private Annotation getNewAnnotation(Class<B> beanClass, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            try {
                Annotation annotation = new Annotation();
                ElementProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, relationships, methodName);
                annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
                return annotation;
            }
            catch (ClassCastException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
                return null;
            }
        }

        private ElementProperties fillInCommonAnnotationProperties(Class<B> beanClass, Annotation annotation, OpenMetadataElement primaryEntity, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
            annotation.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
            ElementProperties elementProperties = null;
            if (primaryEntity.getElementProperties() != null) {
                elementProperties = new ElementProperties(primaryEntity.getElementProperties());
            }
            annotation.setAnnotationType(this.removeAnnotationType(elementProperties));
            annotation.setSummary(this.removeSummary(elementProperties));
            annotation.setConfidenceLevel(this.removeConfidenceLevel(elementProperties));
            annotation.setExpression(this.removeExpression(elementProperties));
            annotation.setExplanation(this.removeExplanation(elementProperties));
            annotation.setAnalysisStep(this.removeAnalysisStep(elementProperties));
            annotation.setJsonProperties(this.removeJsonProperties(elementProperties));
            annotation.setAdditionalProperties(this.removeAdditionalProperties(elementProperties));
            if (relationships != null) {
                for (RelatedMetadataElement relationship : relationships) {
                    if (relationship == null) continue;
                    if (propertyHelper.isTypeOf(relationship, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName)) {
                        annotation.setAnnotationStatus(this.getAnnotationStatusFromProperties(elementProperties));
                        if (!propertyHelper.isTypeOf(relationship.getElement(), OpenMetadataType.ANNOTATION_REVIEW.typeName)) continue;
                        ElementProperties properties = new ElementProperties(relationship.getElement().getElementProperties());
                        annotation.setReviewDate(this.removeReviewDate(properties));
                        annotation.setSteward(this.removeSteward(properties));
                        annotation.setReviewComment(this.removeComment(properties));
                        continue;
                    }
                    if (!propertyHelper.isTypeOf(relationship, OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName)) continue;
                    if (annotation.getAnnotationSubjects() == null) {
                        ArrayList<OpenMetadataElement> openMetadataElements = new ArrayList<OpenMetadataElement>();
                        openMetadataElements.add(relationship.getElement());
                        annotation.setAnnotationSubjects(openMetadataElements);
                        continue;
                    }
                    annotation.getAnnotationSubjects().add(relationship.getElement());
                }
            }
            return elementProperties;
        }

        private AnnotationStatus getAnnotationStatusFromProperties(ElementProperties properties) {
            Map<String, PropertyValue> elementPropertiesMap;
            PropertyValue instancePropertyValue;
            if (properties != null && (instancePropertyValue = (elementPropertiesMap = properties.getPropertyValueMap()).get(OpenMetadataProperty.ANNOTATION_STATUS.name)) instanceof EnumTypePropertyValue) {
                EnumTypePropertyValue enumPropertyValue = (EnumTypePropertyValue)instancePropertyValue;
                for (AnnotationStatus annotationStatus : AnnotationStatus.values()) {
                    if (!annotationStatus.name().equals(enumPropertyValue.getSymbolicName())) continue;
                    return annotationStatus;
                }
            }
            return AnnotationStatus.UNKNOWN_STATUS;
        }
    }

    static class AnnotationBuilder {
        private String openMetadataTypeName;
        private final String annotationType;
        private final String summary;
        private final int confidenceLevel;
        private final String expression;
        private final String explanation;
        private final String analysisStep;
        private final String jsonProperties;
        private final Map<String, String> additionalProperties;
        private final Map<String, Object> extendedProperties;
        private Map<String, String> candidateClassifications = null;
        private List<String> candidateDataClassGUIDs = null;
        private long matchingValues = 0L;
        private long nonMatchingValues = 0L;
        private List<String> dataProfileDataGUIDs = null;
        private List<String> profilePropertyNames = null;
        private int length = 0;
        private String inferredDataType = null;
        private String inferredFormat = null;
        private int inferredLength = 0;
        private int inferredPrecision = 0;
        private int inferredScale = 0;
        private Date profileStartDate = null;
        private Date profileEndDate = null;
        private Map<String, String> profileProperties = null;
        private Map<String, Boolean> profileFlags = null;
        private Map<String, Date> profileDates = null;
        private Map<String, Long> profileCounts = null;
        private Map<String, Double> profileDoubles = null;
        private List<String> valueList = null;
        private Map<String, Integer> valueCount = null;
        private String valueRangeFrom = null;
        private String valueRangeTo = null;
        private String averageValue = null;
        private Map<String, String> dataSourceProperties = null;
        private Date createTime = null;
        private Date modifiedTime = null;
        private long size = 0L;
        private String encoding = null;
        private String qualityDimension = null;
        private int qualityScore = 0;
        private String relatedEntityGUID = null;
        private String relationshipTypeName = null;
        private Map<String, String> relationshipProperties = null;
        private String surveyActivity = null;
        private String actionRequested = null;
        private Map<String, String> actionProperties = null;
        private List<String> requestForActionTargetGUIDs = null;
        private String schemaName = null;
        private String schemaTypeName = null;
        private String informalTerm = null;
        private String informalTopic = null;
        private List<String> candidateGlossaryTermGUIDs = null;
        private List<String> candidateGlossaryCategoryGUIDs = null;
        private static final PropertyHelper propertyHelper = new PropertyHelper();

        AnnotationBuilder(String annotationType, String summary, int confidenceLevel, String expression, String explanation, String analysisStep, String jsonProperties, Map<String, String> additionalProperties, String openMetadataTypeName, Map<String, Object> extendedProperties) {
            this.annotationType = annotationType;
            this.summary = summary;
            this.confidenceLevel = confidenceLevel;
            this.expression = expression;
            this.explanation = explanation;
            this.analysisStep = analysisStep;
            this.jsonProperties = jsonProperties;
            this.additionalProperties = additionalProperties;
            this.openMetadataTypeName = openMetadataTypeName;
            this.extendedProperties = extendedProperties;
        }

        public String getOpenMetadataTypeName() {
            if (this.openMetadataTypeName == null) {
                return OpenMetadataType.ANNOTATION.typeName;
            }
            return this.openMetadataTypeName;
        }

        void setClassificationSubtypeProperties(String annotationTypeName, Map<String, String> candidateClassifications) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.candidateClassifications = candidateClassifications;
        }

        void setDataClassSubtypeProperties(String annotationTypeName, List<String> candidateDataClassGUIDs, long matchingValues, long nonMatchingValues) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.candidateDataClassGUIDs = candidateDataClassGUIDs;
            this.matchingValues = matchingValues;
            this.nonMatchingValues = nonMatchingValues;
        }

        void setDataProfileLogSubtypeProperties(String annotationTypeName, List<String> logFileGUIDs) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.dataProfileDataGUIDs = logFileGUIDs;
        }

        public List<String> getDataProfileDataGUIDs() {
            return this.dataProfileDataGUIDs;
        }

        void setDataProfileSubtypeProperties(String annotationTypeName, List<String> profilePropertyNames, int length, String inferredDataType, String inferredFormat, int inferredLength, int inferredPrecision, int inferredScale, Date profileStartDate, Date profileEndDate, Map<String, String> profileProperties, Map<String, Boolean> profileFlags, Map<String, Date> profileDates, Map<String, Long> profileCounts, Map<String, Double> profileDoubles, List<String> valueList, Map<String, Integer> valueCount, String valueRangeFrom, String valueRangeTo, String averageValue) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.profilePropertyNames = profilePropertyNames;
            this.length = length;
            this.inferredDataType = inferredDataType;
            this.inferredFormat = inferredFormat;
            this.inferredLength = inferredLength;
            this.inferredPrecision = inferredPrecision;
            this.inferredScale = inferredScale;
            this.profileStartDate = profileStartDate;
            this.profileEndDate = profileEndDate;
            this.profileProperties = profileProperties;
            this.profileFlags = profileFlags;
            this.profileDates = profileDates;
            this.profileCounts = profileCounts;
            this.profileDoubles = profileDoubles;
            this.valueList = valueList;
            this.valueCount = valueCount;
            this.valueRangeFrom = valueRangeFrom;
            this.valueRangeTo = valueRangeTo;
            this.averageValue = averageValue;
        }

        void setDataSourceMeasurementSubtypeProperties(String annotationTypeName, Map<String, String> dataSourceProperties) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.dataSourceProperties = dataSourceProperties;
        }

        void setDataSourcePhysicalStatusSubtypeProperties(String annotationTypeName, Map<String, String> dataSourceProperties, Date createTime, Date modifiedTime, long size, String encoding) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.dataSourceProperties = dataSourceProperties;
            this.createTime = createTime;
            this.modifiedTime = modifiedTime;
            this.size = size;
            this.encoding = encoding;
        }

        void setQualitySubtypeProperties(String annotationTypeName, String qualityDimension, int qualityScore) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.qualityDimension = qualityDimension;
            this.qualityScore = qualityScore;
        }

        void setRelationshipAdviceSubtypeProperties(String annotationTypeName, String relatedEntityGUID, String relationshipTypeName, Map<String, String> relationshipProperties) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.relatedEntityGUID = relatedEntityGUID;
            this.relationshipTypeName = relationshipTypeName;
            this.relationshipProperties = relationshipProperties;
        }

        void setRequestForActionSubtypeProperties(String annotationTypeName, String surveyActivity, String actionRequested, Map<String, String> actionProperties, List<String> requestForActionTargetGUIDs) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.surveyActivity = surveyActivity;
            this.actionRequested = actionRequested;
            this.actionProperties = actionProperties;
            this.requestForActionTargetGUIDs = requestForActionTargetGUIDs;
        }

        public List<String> getRequestForActionTargetGUIDs() {
            return this.requestForActionTargetGUIDs;
        }

        void setSchemaAnalysisSubTypeProperties(String annotationTypeName, String schemaName, String schemaTypeName) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.schemaName = schemaName;
            this.schemaTypeName = schemaTypeName;
        }

        void setSemanticSubTypeProperties(String annotationTypeName, String informalTerm, String informalTopic, List<String> candidateGlossaryTermGUIDs, List<String> candidateGlossaryCategoryGUIDs) {
            if (this.openMetadataTypeName == null) {
                this.openMetadataTypeName = annotationTypeName;
            }
            this.informalTerm = informalTerm;
            this.informalTopic = informalTopic;
            this.candidateGlossaryTermGUIDs = candidateGlossaryTermGUIDs;
            this.candidateGlossaryCategoryGUIDs = candidateGlossaryCategoryGUIDs;
        }

        public ElementProperties getElementProperties() {
            ElementProperties properties = propertyHelper.addPropertyMap(null, this.extendedProperties);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.ANNOTATION_TYPE.name, this.annotationType);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.SUMMARY.name, this.summary);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.CONFIDENCE_LEVEL.name, this.confidenceLevel);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.EXPRESSION.name, this.expression);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.EXPLANATION.name, this.explanation);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.ANALYSIS_STEP.name, this.analysisStep);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.JSON_PROPERTIES.name, this.jsonProperties);
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, this.additionalProperties);
            if (OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addClassificationAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.DATA_CLASS_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addDataClassAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addDataProfileAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addResourcePhysicalStatusAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addResourceMeasureAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.QUALITY_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addQualityAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addRelationshipAdviceAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addRequestForActionAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addSchemaAnalysisAnnotationElementProperties(properties);
            }
            if (OpenMetadataType.SEMANTIC_ANNOTATION.typeName.equals(this.openMetadataTypeName)) {
                return this.addSemanticAnnotationElementProperties(properties);
            }
            return properties;
        }

        private ElementProperties addClassificationAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.name, this.candidateClassifications);
            return properties;
        }

        private ElementProperties addDataClassAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringArrayProperty(properties, OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.name, this.candidateDataClassGUIDs);
            properties = propertyHelper.addLongProperty(properties, OpenMetadataProperty.MATCHING_VALUES.name, this.matchingValues);
            properties = propertyHelper.addLongProperty(properties, OpenMetadataProperty.NON_MATCHING_VALUES.name, this.nonMatchingValues);
            return properties;
        }

        private ElementProperties addDataProfileAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringArrayProperty(properties, OpenMetadataProperty.PROFILE_PROPERTY_NAMES.name, this.profilePropertyNames);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.LENGTH.name, this.length);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.INFERRED_DATA_TYPE.name, this.inferredDataType);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.INFERRED_FORMAT.name, this.inferredFormat);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.INFERRED_LENGTH.name, this.inferredLength);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.INFERRED_PRECISION.name, this.inferredPrecision);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.INFERRED_SCALE.name, this.inferredScale);
            properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.PROFILE_START_DATE.name, this.profileStartDate);
            properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.PROFILE_END_DATE.name, this.profileEndDate);
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.PROFILE_PROPERTIES.name, this.profileProperties);
            properties = propertyHelper.addBooleanMapProperty(properties, OpenMetadataProperty.PROFILE_FLAGS.name, this.profileFlags);
            properties = propertyHelper.addDateMapProperty(properties, OpenMetadataProperty.PROFILE_DATES.name, this.profileDates);
            properties = propertyHelper.addLongMapProperty(properties, OpenMetadataProperty.PROFILE_COUNTS.name, this.profileCounts);
            properties = propertyHelper.addDoubleMapProperty(properties, OpenMetadataProperty.PROFILE_DOUBLES.name, this.profileDoubles);
            properties = propertyHelper.addStringArrayProperty(properties, OpenMetadataProperty.VALUE_LIST.name, this.valueList);
            properties = propertyHelper.addIntMapProperty(properties, OpenMetadataProperty.VALUE_COUNT.name, this.valueCount);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.VALUE_RANGE_FROM.name, this.valueRangeFrom);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.VALUE_RANGE_TO.name, this.valueRangeTo);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.AVERAGE_VALUE.name, this.averageValue);
            return properties;
        }

        private ElementProperties addResourcePhysicalStatusAnnotationElementProperties(ElementProperties properties) {
            properties = this.addResourceMeasureAnnotationElementProperties(properties);
            properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.RESOURCE_CREATE_TIME.name, this.createTime);
            properties = propertyHelper.addDateProperty(properties, OpenMetadataProperty.RESOURCE_UPDATE_TIME.name, this.modifiedTime);
            properties = propertyHelper.addLongProperty(properties, OpenMetadataProperty.SIZE.name, this.size);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.ENCODING.name, this.encoding);
            return properties;
        }

        private ElementProperties addResourceMeasureAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.RESOURCE_PROPERTIES.name, this.dataSourceProperties);
            return properties;
        }

        private ElementProperties addQualityAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.QUALITY_DIMENSION.name, this.qualityDimension);
            properties = propertyHelper.addIntProperty(properties, OpenMetadataProperty.QUALITY_SCORE.name, this.qualityScore);
            return properties;
        }

        private ElementProperties addRelationshipAdviceAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.RELATED_ENTITY_GUID.name, this.relatedEntityGUID);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name, this.relationshipTypeName);
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.RELATIONSHIP_PROPERTIES.name, this.relationshipProperties);
            return properties;
        }

        private ElementProperties addRequestForActionAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.ACTION_SOURCE_NAME.name, this.surveyActivity);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.ACTION_REQUESTED.name, this.actionRequested);
            properties = propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.ACTION_PROPERTIES.name, this.actionProperties);
            return properties;
        }

        private ElementProperties addSchemaAnalysisAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.SCHEMA_NAME.name, this.schemaName);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.SCHEMA_TYPE.name, this.schemaTypeName);
            return properties;
        }

        private ElementProperties addSemanticAnnotationElementProperties(ElementProperties properties) {
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.INFORMAL_TERM.name, this.informalTerm);
            properties = propertyHelper.addStringProperty(properties, OpenMetadataProperty.INFORMAL_CATEGORY.name, this.informalTopic);
            properties = propertyHelper.addStringArrayProperty(properties, OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.name, this.candidateGlossaryTermGUIDs);
            properties = propertyHelper.addStringArrayProperty(properties, OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.name, this.candidateGlossaryCategoryGUIDs);
            return properties;
        }
    }
}

