/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.platformservices.client.PlatformServicesRESTClient;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;

public class PlatformServicesClient {
    private final PlatformServicesRESTClient restClient;
    private final String platformRootURL;
    protected AuditLog auditLog;
    private final String retrieveURLTemplatePrefix = "/open-metadata/platform-services/users/{1}/server-platform";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public PlatformServicesClient(String platformName, String platformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, auditLog);
    }

    public PlatformServicesClient(String platformName, String platformRootURL) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL);
    }

    public PlatformServicesClient(String platformName, String platformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, userId, password, auditLog);
    }

    public PlatformServicesClient(String platformName, String platformRootURL, String userId, String password) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, userId, password);
    }

    public Date getPlatformStartTime(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPlatformStartTime";
        this.invalidParameterHandler.validateUserId(userId, "getPlatformStartTime");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/start-time";
        return this.restClient.callDateGetRESTCall("getPlatformStartTime", urlTemplate, userId);
    }

    public String getPlatformOrigin(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPlatformOrigin";
        this.invalidParameterHandler.validateUserId(userId, "getPlatformOrigin");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/origin";
        return this.restClient.callStringGetRESTCall("getPlatformOrigin", urlTemplate, userId);
    }

    public void setPlatformSecurityConnection(String userId, Connection connection) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "setPlatformSecurityConnection";
        String parameterName = "connection";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/security/connection";
        this.invalidParameterHandler.validateUserId(userId, "setPlatformSecurityConnection");
        this.invalidParameterHandler.validateConnection(connection, "connection", "setPlatformSecurityConnection");
        PlatformSecurityRequestBody requestBody = new PlatformSecurityRequestBody();
        requestBody.setPlatformSecurityConnection(connection);
        this.restClient.callVoidPostRESTCall("setPlatformSecurityConnection", urlTemplate, requestBody, userId);
    }

    public void clearPlatformSecurityConnection(String userId) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "clearPlatformSecurityConnection";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/security/connection";
        this.invalidParameterHandler.validateUserId(userId, "clearPlatformSecurityConnection");
        this.restClient.callVoidDeleteRESTCall("clearPlatformSecurityConnection", urlTemplate, userId);
    }

    public Connection getPlatformSecurityConnection(String userId) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getPlatformSecurityConnection";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/security/connection";
        OCFConnectionResponse restResult = this.restClient.callOCFConnectionGetRESTCall("getPlatformSecurityConnection", urlTemplate, userId);
        return restResult.getConnection();
    }

    public ConnectorType getConnectorType(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorType";
        String connectorProviderParameterName = "connectorProviderClassName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorType");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "getConnectorType");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/connector-types/{1}";
        OCFConnectorTypeResponse restResult = this.restClient.callOCFConnectorTypeGetRESTCall("getConnectorType", urlTemplate, userId, connectorProviderClassName);
        return restResult.getConnectorType();
    }

    public List<RegisteredOMAGService> getAccessServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAccessServices";
        this.invalidParameterHandler.validateUserId(userId, "getAccessServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/access-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getAccessServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getEngineServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEngineServices";
        this.invalidParameterHandler.validateUserId(userId, "getEngineServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/engine-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getEngineServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getViewServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getViewServices";
        this.invalidParameterHandler.validateUserId(userId, "getViewServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/view-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getViewServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getGovernanceServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServices";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/governance-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getGovernanceServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getIntegrationServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationServices";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/integration-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getIntegrationServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getCommonServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCommonServices";
        this.invalidParameterHandler.validateUserId(userId, "getCommonServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/common-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getCommonServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getAllServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllServices";
        this.invalidParameterHandler.validateUserId(userId, "getAllServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getAllServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public String activateWithStoredConfig(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "activateWithStoredConfig";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance";
        this.invalidParameterHandler.validateUserId(userId, "activateWithStoredConfig");
        this.invalidParameterHandler.validateName(serverName, "serverName", "activateWithStoredConfig");
        SuccessMessageResponse restResult = this.restClient.callSuccessMessagePostRESTCall("activateWithStoredConfig", urlTemplate, null, userId, serverName);
        return restResult.getSuccessMessage();
    }

    public String activateWithSuppliedConfig(String userId, OMAGServerConfig configuration) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "activateWithSuppliedConfig";
        String parameterName = "configuration";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance/configuration";
        this.invalidParameterHandler.validateUserId(userId, "activateWithSuppliedConfig");
        this.invalidParameterHandler.validateObject(configuration, "configuration", "activateWithSuppliedConfig");
        SuccessMessageResponse restResult = this.restClient.callSuccessMessagePostRESTCall("activateWithSuppliedConfig", urlTemplate, configuration, userId, configuration.getLocalServerName());
        return restResult.getSuccessMessage();
    }

    public void shutdownServer(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "shutdownServer";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance";
        this.invalidParameterHandler.validateUserId(userId, "shutdownServer");
        this.invalidParameterHandler.validateName(serverName, "serverName", "shutdownServer");
        this.restClient.callVoidDeleteRESTCall("shutdownServer", urlTemplate, userId, serverName);
    }

    public void shutdownAllServers(String userId) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "shutdownAllServers";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/instance";
        this.invalidParameterHandler.validateUserId(userId, "shutdownAllServers");
        this.restClient.callVoidDeleteRESTCall("shutdownAllServers", urlTemplate, userId);
    }

    public void shutdownAndUnregisterServer(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "shutdownAndUnregisterServer";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}";
        this.invalidParameterHandler.validateUserId(userId, "shutdownAndUnregisterServer");
        this.invalidParameterHandler.validateName(serverName, "serverName", "shutdownAndUnregisterServer");
        this.restClient.callVoidDeleteRESTCall("shutdownAndUnregisterServer", urlTemplate, userId, serverName);
    }

    public void shutdownAndUnregisterAllServers(String userId) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "shutdownAndUnregisterAllServers";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers";
        this.invalidParameterHandler.validateUserId(userId, "shutdownAndUnregisterAllServers");
        this.restClient.callVoidDeleteRESTCall("shutdownAndUnregisterAllServers", urlTemplate, userId);
    }

    public void shutdownPlatform(String userId) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "shutdownPlatform";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/instance";
        this.invalidParameterHandler.validateUserId(userId, "shutdownPlatform");
        this.restClient.callVoidDeleteRESTCall("shutdownPlatform", urlTemplate, userId);
    }

    public List<String> getKnownServers(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getKnownServers";
        this.invalidParameterHandler.validateUserId(userId, "getKnownServers");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers";
        ServerListResponse restResult = this.restClient.callServerListGetRESTCall("getKnownServers", urlTemplate, userId);
        return restResult.getServerList();
    }

    public boolean isServerKnown(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "isServerKnown";
        this.invalidParameterHandler.validateUserId(userId, "isServerKnown");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/is-known";
        BooleanResponse restResult = this.restClient.callBooleanGetRESTCall("isServerKnown", urlTemplate, userId);
        return restResult.getFlag();
    }

    public List<String> getActiveServers(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveServers";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServers");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/active";
        ServerListResponse restResult = this.restClient.callServerListGetRESTCall("getActiveServers", urlTemplate, userId);
        return restResult.getServerList();
    }

    public ServerStatus getServerStatus(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerStatus";
        this.invalidParameterHandler.validateUserId(userId, "getServerStatus");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/" + serverName + "/status";
        ServerStatusResponse restResult = this.restClient.callServerStatusGetRESTCall("getServerStatus", urlTemplate, userId);
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setServerName(restResult.getServerName());
        serverStatus.setIsActive(restResult.isActive());
        serverStatus.setServerStartTime(restResult.getServerStartTime());
        serverStatus.setServerEndTime(restResult.getServerEndTime());
        serverStatus.setServerHistory(restResult.getServerHistory());
        return serverStatus;
    }

    public OMAGServerConfig getActiveConfiguration(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getActiveConfiguration";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance/configuration";
        this.invalidParameterHandler.validateUserId(userId, "getActiveConfiguration");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveConfiguration");
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getActiveConfiguration", urlTemplate, userId, serverName);
        return restResult.getOMAGServerConfig();
    }

    public ServerServicesStatus getActiveServerStatus(String userId, String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getActiveServerStatus";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance/status";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServerStatus");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveServerStatus");
        OMAGServerStatusResponse restResult = this.restClient.callOMAGServerStatusGetRESTCall("getActiveServerStatus", urlTemplate, userId, serverName);
        return restResult.getServerStatus();
    }

    public List<String> getActiveServicesForServer(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveServices";
        String serverNameParameter = "serverName";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServices");
        this.invalidParameterHandler.validateName(serverName, "serverName", "getActiveServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/" + serverName + "/services";
        ServerServicesListResponse restResult = this.restClient.callServiceListGetRESTCall("getActiveServices", urlTemplate, userId);
        return restResult.getServerServicesList();
    }

    public void addOpenMetadataArchiveFile(String userId, String serverName, String fileName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "fileName";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance/open-metadata-archives/file";
        this.invalidParameterHandler.validateUserId(userId, "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(serverName, "serverName", "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(fileName, "fileName", "addOpenMetadataArchiveFile");
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", urlTemplate, fileName, userId, serverName);
    }

    public void addOpenMetadataArchive(String userId, String serverName, Connection connection) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "connection";
        String serverNameParameter = "serverName";
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/{1}/instance/open-metadata-archives/connection";
        this.invalidParameterHandler.validateUserId(userId, "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateName(serverName, "serverName", "addOpenMetadataArchiveFile");
        this.invalidParameterHandler.validateConnection(connection, "connection", "addOpenMetadataArchiveFile");
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", urlTemplate, connection, userId, serverName);
    }
}

