/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.client;

import java.util.Date;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectorTypesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;

class PlatformServicesRESTClient
extends FFDCRESTClient {
    PlatformServicesRESTClient(String platformName, String platformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(platformName, platformURLRoot, auditLog);
    }

    PlatformServicesRESTClient(String platformName, String platformURLRoot) throws InvalidParameterException {
        super(platformName, platformURLRoot);
    }

    PlatformServicesRESTClient(String platformName, String platformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(platformName, platformURLRoot, userId, password, auditLog);
    }

    PlatformServicesRESTClient(String platformName, String platformURLRoot, String userId, String password) throws InvalidParameterException {
        super(platformName, platformURLRoot, userId, password);
    }

    String callStringGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String restResult = this.callGetRESTCall(methodName, String.class, urlTemplate, params);
        return restResult;
    }

    Date callDateGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Date restResult = this.callGetRESTCall(methodName, Date.class, urlTemplate, params);
        return restResult;
    }

    ServerStatusResponse callServerStatusGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ServerStatusResponse restResult = this.callGetRESTCall(methodName, ServerStatusResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    public OCFConnectorTypeResponse callOCFConnectorTypeGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OCFConnectorTypeResponse restResult = this.callGetRESTCall(methodName, OCFConnectorTypeResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    OCFConnectorTypesResponse callConnectorTypeListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OCFConnectorTypesResponse restResult = this.callGetRESTCall(methodName, OCFConnectorTypesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    ServerServicesListResponse callServiceListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ServerServicesListResponse restResult = this.callGetRESTCall(methodName, ServerServicesListResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    ServerListResponse callServerListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ServerListResponse restResult = this.callGetRESTCall(methodName, ServerListResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    RegisteredOMAGServicesResponse callRegisteredOMAGServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        RegisteredOMAGServicesResponse restResult = this.callGetRESTCall(methodName, RegisteredOMAGServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    SuccessMessageResponse callSuccessMessagePostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SuccessMessageResponse restResult = this.callPostRESTCall(methodName, SuccessMessageResponse.class, urlTemplate, requestBody, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    OMAGServerStatusResponse callOMAGServerStatusGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMAGServerStatusResponse restResult = this.callGetRESTCall(methodName, OMAGServerStatusResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    VoidResponse callVoidDeleteRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        VoidResponse restResult = this.callDeleteRESTCall(methodName, VoidResponse.class, urlTemplate, null, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    OMAGServerConfigResponse callOMAGServerConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMAGServerConfigResponse restResult = this.callGetRESTCall(methodName, OMAGServerConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }

    OCFConnectionResponse callOCFConnectionGetRESTCall(String methodName, String urlTemplate, Object ... params) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OCFConnectionResponse restResult = this.callGetRESTCall(methodName, OCFConnectionResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, restResult);
        return restResult;
    }
}

